/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.layout.alias;

import java.util.Comparator;
import lcsb.mapviewer.common.comparator.DoubleComparator;
import lcsb.mapviewer.common.comparator.IntegerComparator;
import lcsb.mapviewer.common.comparator.StringComparator;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import lcsb.mapviewer.model.map.layout.alias.CompartmentAlias;
import lcsb.mapviewer.model.map.layout.alias.CompartmentAliasComparator;
import lcsb.mapviewer.model.map.layout.alias.ComplexAlias;
import lcsb.mapviewer.model.map.layout.alias.ComplexAliasComparator;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAlias;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAliasComparator;
import lcsb.mapviewer.model.map.model.AliasSubmodelConnectionComparator;
import org.apache.log4j.Logger;

public class AliasComparator
implements Comparator<Alias> {
    private static Logger logger = Logger.getLogger(AliasComparator.class);
    private double epsilon;

    public AliasComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public AliasComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(Alias arg0, Alias arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof ComplexAlias) {
                ComplexAliasComparator caComparator = new ComplexAliasComparator(this.epsilon);
                return caComparator.compare((ComplexAlias)arg0, (ComplexAlias)arg1);
            }
            if (arg0 instanceof CompartmentAlias) {
                CompartmentAliasComparator caComparator = new CompartmentAliasComparator(this.epsilon);
                return caComparator.compare((CompartmentAlias)arg0, (CompartmentAlias)arg1);
            }
            if (arg0 instanceof SpeciesAlias) {
                SpeciesAliasComparator caComparator = new SpeciesAliasComparator(this.epsilon);
                return caComparator.compare((SpeciesAlias)arg0, (SpeciesAlias)arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        logger.debug("Mismatch class type: " + arg0.getClass() + ", " + arg1.getClass());
        return -1;
    }

    public int internalCompare(Alias arg0, Alias arg1) {
        StringComparator stringComparator = new StringComparator();
        IntegerComparator integerComparator = new IntegerComparator();
        DoubleComparator doubleComparator = new DoubleComparator(this.epsilon);
        if (stringComparator.compare(arg0.getAliasId(), arg1.getAliasId()) != 0) {
            logger.debug("AliasId different: " + arg0.getAliasId() + ", " + arg1.getAliasId());
            return stringComparator.compare(arg0.getAliasId(), arg1.getAliasId());
        }
        if (doubleComparator.compare(arg0.getX(), arg1.getX()) != 0) {
            logger.debug("X different: " + arg0.getX() + ", " + arg1.getX());
            return doubleComparator.compare(arg0.getX(), arg1.getX());
        }
        if (doubleComparator.compare(arg0.getY(), arg1.getY()) != 0) {
            logger.debug("Y different: " + arg0.getY() + ", " + arg1.getY());
            return doubleComparator.compare(arg0.getY(), arg1.getY());
        }
        if (doubleComparator.compare(arg0.getWidth(), arg1.getWidth()) != 0) {
            logger.debug("Width different: " + arg0.getWidth() + ", " + arg1.getWidth());
            return doubleComparator.compare(arg0.getWidth(), arg1.getWidth());
        }
        if (doubleComparator.compare(arg0.getHeight(), arg1.getHeight()) != 0) {
            logger.debug("Height different: " + arg0.getHeight() + ", " + arg1.getHeight());
            return doubleComparator.compare(arg0.getHeight(), arg1.getHeight());
        }
        if (doubleComparator.compare(arg0.getFontSize(), arg1.getFontSize()) != 0) {
            logger.debug("Font size different: " + arg0.getFontSize() + ", " + arg1.getFontSize());
            return doubleComparator.compare(arg0.getFontSize(), arg1.getFontSize());
        }
        if (integerComparator.compare(arg0.getVisibilityLevel(), arg1.getVisibilityLevel()) != 0) {
            logger.debug("Visibility level different: " + arg0.getVisibilityLevel() + ", " + arg1.getVisibilityLevel());
            return integerComparator.compare(arg0.getVisibilityLevel(), arg1.getVisibilityLevel());
        }
        if (integerComparator.compare(arg0.getColor().getRGB(), arg1.getColor().getRGB()) != 0) {
            logger.debug("Color different: " + arg0.getColor().getRGB() + ", " + arg1.getColor().getRGB());
            return integerComparator.compare(arg0.getColor().getRGB(), arg1.getColor().getRGB());
        }
        AliasSubmodelConnectionComparator ascc = new AliasSubmodelConnectionComparator(this.epsilon);
        int status = ascc.compare(arg0.getSubmodel(), arg1.getSubmodel());
        if (status != 0) {
            logger.debug("Alias submodel different: " + arg0.getSubmodel() + ", " + arg1.getSubmodel());
            return status;
        }
        return 0;
    }
}

