/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.graphics;

import java.util.Comparator;
import lcsb.mapviewer.common.comparator.DoubleComparator;
import lcsb.mapviewer.model.graphics.ArrowTypeData;
import lcsb.mapviewer.model.graphics.PolylineDataComparator;
import org.apache.log4j.Logger;

public class ArrowTypeDataComparator
implements Comparator<ArrowTypeData> {
    private Logger logger = Logger.getLogger(PolylineDataComparator.class);
    private double epsilon;

    public ArrowTypeDataComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public ArrowTypeDataComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(ArrowTypeData arg0, ArrowTypeData arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            return this.internalCompare(arg0, arg1);
        }
        return -1;
    }

    private int internalCompare(ArrowTypeData arg0, ArrowTypeData arg1) {
        DoubleComparator doubleComparator = new DoubleComparator(this.epsilon);
        if (arg0.getArrowType().compareTo(arg1.getArrowType()) != 0) {
            this.logger.debug("Different arrow type: " + (Object)((Object)arg0.getArrowType()) + ", " + (Object)((Object)arg1.getArrowType()));
            return arg0.getArrowType().compareTo(arg1.getArrowType());
        }
        if (arg0.getArrowLineType().compareTo(arg1.getArrowLineType()) != 0) {
            this.logger.debug("Different arrow line type: " + (Object)((Object)arg0.getArrowLineType()) + ", " + (Object)((Object)arg1.getArrowLineType()));
            return arg0.getArrowLineType().compareTo(arg1.getArrowLineType());
        }
        if (doubleComparator.compare(arg0.getLen(), arg1.getLen()) != 0) {
            this.logger.debug("Different length: " + arg0.getLen() + ", " + arg1.getLen());
            return doubleComparator.compare(arg0.getLen(), arg1.getLen());
        }
        if (doubleComparator.compare(arg0.getAngle(), arg1.getAngle()) != 0) {
            this.logger.debug("Different angle: " + arg0.getAngle() + ", " + arg1.getAngle());
            return doubleComparator.compare(arg0.getAngle(), arg1.getAngle());
        }
        return 0;
    }
}

