/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lcsb.mapviewer.model.ProjectStatus;
import lcsb.mapviewer.model.map.model.Model;
import lcsb.mapviewer.model.map.model.ModelData;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="project_table")
public class Project {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="idDb", unique=true, nullable=false)
    private int id;
    private String name;
    private ProjectStatus status = ProjectStatus.UNKNOWN;
    private double progress = 0.0;
    private String errors = null;
    @Cascade(value={CascadeType.ALL})
    @OneToMany(mappedBy="project", orphanRemoval=true)
    private Set<ModelData> models = new HashSet<ModelData>();

    public Project() {
    }

    public Project(String projectName) {
        this.name = projectName;
    }

    public void addModel(ModelData model) {
        this.models.add(model);
        model.setProject(this);
    }

    public void addModel(Model model) {
        this.models.add(model.getModelData());
        model.setProject(this);
    }

    public void removeModel(ModelData model) {
        this.models.remove(model);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProjectStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProjectStatus status) {
        this.status = status;
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public Set<ModelData> getModels() {
        return this.models;
    }

    public void setModels(Set<ModelData> models) {
        this.models = models;
    }

    public String getErrors() {
        return this.errors;
    }

    public void setErrors(String errors) {
        this.errors = errors;
    }
}

