/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.structure;

import java.util.ArrayList;
import java.util.List;
import lcsb.mapviewer.model.map.species.ComplexSpecies;
import lcsb.mapviewer.model.map.species.Gene;
import lcsb.mapviewer.model.map.species.Protein;
import lcsb.mapviewer.model.map.species.Rna;
import lcsb.mapviewer.model.map.species.SimpleMolecule;
import lcsb.mapviewer.model.map.species.Species;
import lcsb.mapviewer.model.map.species.fields.ModificationResidue;
import lcsb.mapviewer.model.map.species.fields.RnaRegion;
import org.apache.log4j.Logger;

public class SpeciesState {
    private Logger logger;
    private int homodimer;
    private String structuralState;
    private List<ModificationResidue> modifications;

    public SpeciesState(SpeciesState state) {
        this.logger = Logger.getLogger(SpeciesState.class.getName());
        this.homodimer = 1;
        this.structuralState = null;
        this.modifications = new ArrayList<ModificationResidue>();
        this.homodimer = state.homodimer;
        this.structuralState = new String(state.getStructuralState());
        for (ModificationResidue s : state.modifications) {
            this.addModificationResidue(new ModificationResidue(s));
        }
    }

    public void addModificationResidue(ModificationResidue modificationResidue) {
        for (ModificationResidue modification : this.modifications) {
            if (!modification.getIdModificationResidue().equals(modificationResidue.getIdModificationResidue())) continue;
            modification.update(modificationResidue);
            return;
        }
        this.modifications.add(modificationResidue);
    }

    public SpeciesState() {
        this.logger = Logger.getLogger(SpeciesState.class.getName());
        this.homodimer = 1;
        this.structuralState = null;
        this.modifications = new ArrayList<ModificationResidue>();
    }

    public SpeciesState(Species species) {
        block4: {
            block7: {
                block6: {
                    block5: {
                        block3: {
                            this.logger = Logger.getLogger(SpeciesState.class.getName());
                            this.homodimer = 1;
                            this.structuralState = null;
                            this.modifications = new ArrayList<ModificationResidue>();
                            if (!(species instanceof Protein)) break block3;
                            Protein protein = (Protein)species;
                            this.setHomodimer(protein.getHomodimer());
                            this.setStructuralState(protein.getStructuralState());
                            for (ModificationResidue mr : protein.getModificationResidues()) {
                                this.addModificationResidue(mr);
                            }
                            break block4;
                        }
                        if (!(species instanceof SimpleMolecule)) break block5;
                        SimpleMolecule simpleMolecule = (SimpleMolecule)species;
                        this.setHomodimer(simpleMolecule.getHomodimer());
                        break block4;
                    }
                    if (!(species instanceof ComplexSpecies)) break block6;
                    ComplexSpecies complex = (ComplexSpecies)species;
                    this.setHomodimer(complex.getHomodimer());
                    this.setStructuralState(complex.getStructuralState());
                    break block4;
                }
                if (!(species instanceof Rna)) break block7;
                Rna rna = (Rna)species;
                for (RnaRegion region : rna.getRegions()) {
                    ModificationResidue mr = new ModificationResidue();
                    mr.setIdModificationResidue(region.getIdRnaRegion());
                    mr.setSize(region.getSize());
                    mr.setState(region.getState());
                    this.addModificationResidue(mr);
                }
                break block4;
            }
            if (!(species instanceof Gene)) break block4;
            Gene gene = (Gene)species;
            for (ModificationResidue mr : gene.getModificationResidues()) {
                this.addModificationResidue(mr);
            }
        }
    }

    public void setHomodimer(String homodimer) {
        try {
            this.homodimer = Integer.parseInt(homodimer);
        }
        catch (Exception e) {
            this.logger.debug("Invalid homodir value: " + homodimer);
            this.homodimer = 1;
        }
    }

    public int getHomodimer() {
        return this.homodimer;
    }

    public void setHomodimer(int homodimer) {
        this.homodimer = homodimer;
    }

    public String getStructuralState() {
        return this.structuralState;
    }

    public void setStructuralState(String structuralState) {
        this.structuralState = structuralState;
    }

    public List<ModificationResidue> getModifications() {
        return this.modifications;
    }

    public void setModifications(List<ModificationResidue> modifications) {
        this.modifications = modifications;
    }
}

