/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.species;

import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.model.map.species.AntisenseRna;
import lcsb.mapviewer.model.map.species.ComplexSpecies;
import lcsb.mapviewer.model.map.species.Degraded;
import lcsb.mapviewer.model.map.species.Drug;
import lcsb.mapviewer.model.map.species.Gene;
import lcsb.mapviewer.model.map.species.Ion;
import lcsb.mapviewer.model.map.species.Phenotype;
import lcsb.mapviewer.model.map.species.Protein;
import lcsb.mapviewer.model.map.species.Rna;
import lcsb.mapviewer.model.map.species.SimpleMolecule;
import lcsb.mapviewer.model.map.species.Species;
import lcsb.mapviewer.model.map.species.Unknown;

public enum SpeciesMapping {
    PROTEIN(Protein.class, "PROTEIN"),
    GENE(Gene.class, "GENE"),
    COMPLEX(ComplexSpecies.class, "COMPLEX"),
    SIMPLE_MOLECULE(SimpleMolecule.class, "SIMPLE_MOLECULE"),
    ION(Ion.class, "ION"),
    PHENOTYPE(Phenotype.class, "PHENOTYPE"),
    DRUG(Drug.class, "DRUG"),
    RNA(Rna.class, "RNA"),
    ANTISENSE_RNA(AntisenseRna.class, "ANTISENSE_RNA"),
    UNKNOWN(Unknown.class, "UNKNOWN"),
    DEGRADED(Degraded.class, "DEGRADED");

    private String cellDesignerString;
    private Class<? extends Species> clazz;

    private SpeciesMapping(Class<? extends Species> clazz, String cellDesignerString) {
        this.cellDesignerString = cellDesignerString;
        this.clazz = clazz;
    }

    public String getCellDesignerString() {
        return this.cellDesignerString;
    }

    public Class<? extends Species> getClazz() {
        return this.clazz;
    }

    public Species createSpecies(Species result) {
        try {
            return this.clazz.getConstructor(Species.class).newInstance(result);
        }
        catch (Exception e) {
            throw new InvalidStateException(e);
        }
    }

    public static SpeciesMapping getMappingByString(String string) {
        for (SpeciesMapping mapping : SpeciesMapping.values()) {
            if (!mapping.getCellDesignerString().equals(string)) continue;
            return mapping;
        }
        return null;
    }

    public static SpeciesMapping getMappingByClass(Class<? extends Species> searchClazz) {
        for (SpeciesMapping mapping : SpeciesMapping.values()) {
            if (!mapping.getClazz().isAssignableFrom(searchClazz)) continue;
            return mapping;
        }
        return null;
    }
}

