/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.species;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lcsb.mapviewer.common.Pair;
import lcsb.mapviewer.common.XmlParser;
import lcsb.mapviewer.common.exception.InvalidXmlSchemaException;
import lcsb.mapviewer.converter.model.celldesigner.annotation.RestAnnotationParser;
import lcsb.mapviewer.converter.model.celldesigner.annotation.XmlAnnotationParser;
import lcsb.mapviewer.converter.model.celldesigner.species.AntisenseRnaXmlParser;
import lcsb.mapviewer.converter.model.celldesigner.species.GeneXmlParser;
import lcsb.mapviewer.converter.model.celldesigner.species.ProteinXmlParser;
import lcsb.mapviewer.converter.model.celldesigner.species.RnaXmlParser;
import lcsb.mapviewer.converter.model.celldesigner.species.SpeciesSbmlParser;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.InconsistentModelException;
import lcsb.mapviewer.model.map.MiriamData;
import lcsb.mapviewer.model.map.layout.alias.ComplexAlias;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAlias;
import lcsb.mapviewer.model.map.model.Model;
import lcsb.mapviewer.model.map.species.AntisenseRna;
import lcsb.mapviewer.model.map.species.ComplexSpecies;
import lcsb.mapviewer.model.map.species.Gene;
import lcsb.mapviewer.model.map.species.Protein;
import lcsb.mapviewer.model.map.species.Rna;
import lcsb.mapviewer.model.map.species.Species;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpeciesCollectionXmlParser
extends XmlParser {
    private Logger logger = Logger.getLogger(SpeciesCollectionXmlParser.class.getName());
    private Model model = null;
    private RnaXmlParser rnaParser = new RnaXmlParser();
    private GeneXmlParser geneParser = new GeneXmlParser();
    private ProteinXmlParser proteinParser = new ProteinXmlParser();
    private AntisenseRnaXmlParser antisenseRnaParser = new AntisenseRnaXmlParser();
    private SpeciesSbmlParser sbmlSpeciesParser = null;
    private RestAnnotationParser rap = new RestAnnotationParser();
    private XmlAnnotationParser xap = new XmlAnnotationParser();

    public SpeciesCollectionXmlParser(Model model) {
        this.model = model;
        this.sbmlSpeciesParser = new SpeciesSbmlParser(model);
    }

    public List<Pair<String, ? extends Species>> parseXmlRnaCollection(Node rnaNode) {
        ArrayList<Pair<String, ? extends Species>> result = new ArrayList<Pair<String, ? extends Species>>();
        NodeList nodes = rnaNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:RNA")) {
                Pair<String, Rna> rna = this.rnaParser.parseXmlElement(node, null);
                result.add(rna);
                continue;
            }
            this.logger.warn("Unknown element of celldesigner:listOfRNAs: " + node.getNodeName());
        }
        return result;
    }

    public String rnaCollectionToXmlString(Collection<Rna> collection) {
        StringBuilder result = new StringBuilder();
        result.append("<celldesigner:listOfRNAs>");
        for (Rna species : collection) {
            result.append(this.rnaParser.toXml(species));
        }
        result.append("</celldesigner:listOfRNAs>\n");
        return result.toString();
    }

    public List<Pair<String, ? extends Species>> parseXmlGeneCollection(Node geneNode) throws InvalidXmlSchemaException {
        ArrayList<Pair<String, ? extends Species>> result = new ArrayList<Pair<String, ? extends Species>>();
        NodeList nodes = geneNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:gene")) {
                Pair<String, Gene> gene = this.geneParser.parseXmlElement(node, null);
                result.add(gene);
                continue;
            }
            this.logger.warn("Unknown element of celldesigner:listOfGenes: " + node.getNodeName());
        }
        return result;
    }

    public String geneCollectionToXmlString(Collection<Gene> collection) {
        StringBuilder result = new StringBuilder();
        result.append("<celldesigner:listOfGenes>");
        for (Gene species : collection) {
            result.append(this.geneParser.toXml(species));
        }
        result.append("</celldesigner:listOfGenes>\n");
        return result.toString();
    }

    public List<Pair<String, ? extends Species>> parseXmlProteinCollection(Node proteinNode) throws InvalidXmlSchemaException {
        ArrayList<Pair<String, ? extends Species>> result = new ArrayList<Pair<String, ? extends Species>>();
        NodeList nodes = proteinNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:protein")) {
                Pair<String, Protein> protein = this.proteinParser.parseXmlElement(node, null);
                result.add(protein);
                continue;
            }
            this.logger.warn("Unknown element of celldesigner:listOfProteins: " + node.getNodeName());
        }
        return result;
    }

    public String proteinCollectionToXmlString(Collection<Protein> collection) {
        StringBuilder result = new StringBuilder();
        result.append("<celldesigner:listOfProteins>");
        for (Protein species : collection) {
            result.append(this.proteinParser.toXml(species));
        }
        result.append("</celldesigner:listOfProteins>\n");
        return result.toString();
    }

    public List<Pair<String, ? extends Species>> parseXmlAntisenseRnaCollection(Node rnaNode) throws InvalidXmlSchemaException {
        ArrayList<Pair<String, ? extends Species>> result = new ArrayList<Pair<String, ? extends Species>>();
        NodeList nodes = rnaNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:AntisenseRNA")) {
                Pair<String, AntisenseRna> antisenseRna = this.antisenseRnaParser.parseXmlElement(node, null);
                result.add(antisenseRna);
                continue;
            }
            this.logger.warn("Unknown element of celldesigner:listOfAntisenseRNAs: " + node.getNodeName());
        }
        return result;
    }

    public String antisenseRnaCollectionToXmlString(Collection<AntisenseRna> collection) {
        StringBuilder result = new StringBuilder();
        result.append("<celldesigner:listOfAntisenseRNAs>");
        for (AntisenseRna species : collection) {
            result.append(this.antisenseRnaParser.toXml(species));
        }
        result.append("</celldesigner:listOfAntisenseRNAs>\n");
        return result.toString();
    }

    public List<Pair<String, ? extends Species>> parseSbmlSpeciesCollection(Node spieciesNode, List<String> warnings) throws InvalidXmlSchemaException {
        ArrayList<Pair<String, ? extends Species>> result = new ArrayList<Pair<String, ? extends Species>>();
        NodeList nodes = spieciesNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("species") || node.getNodeName().equalsIgnoreCase("celldesigner:species")) {
                Pair<String, Species> sp = this.sbmlSpeciesParser.parseXmlElement(node, warnings);
                result.add(sp);
                continue;
            }
            this.logger.warn("Unknown element of annotation: " + node.getNodeName());
        }
        return result;
    }

    public String speciesCollectionToSbmlString(Collection<Species> collection) throws InconsistentModelException {
        StringBuilder result = new StringBuilder();
        result.append("<listOfSpecies>");
        for (Species species : collection) {
            boolean add = false;
            List<SpeciesAlias> aliases = species.getModelData().getModel().getAliasesBySpeciesId(species.getIdSpecies());
            if (!(aliases.get(0).getParent() instanceof ComplexAlias)) {
                add = true;
            }
            if (!add) continue;
            result.append(this.sbmlSpeciesParser.toXml(species));
        }
        result.append("</listOfSpecies>\n");
        return result.toString();
    }

    public List<Pair<String, ? extends Species>> parseIncludedSpeciesCollection(Node spieciesNode, List<String> warnings) throws InvalidXmlSchemaException {
        ArrayList<Pair<String, ? extends Species>> result = new ArrayList<Pair<String, ? extends Species>>();
        NodeList nodes = spieciesNode.getChildNodes();
        SpeciesSbmlParser parser = new SpeciesSbmlParser(this.model);
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:species")) {
                String idIncluded = this.getNodeAttr("id", node);
                String nameIncluded = this.getNodeAttr("name", node);
                if (idIncluded == null) {
                    this.logger.warn("Included species does not contain id");
                    continue;
                }
                Node annNode = null;
                Node notesNode = null;
                for (int y = 0; y < node.getChildNodes().getLength(); ++y) {
                    Node child = node.getChildNodes().item(y);
                    if (child.getNodeType() != 1) continue;
                    if (child.getNodeName().equalsIgnoreCase("celldesigner:annotation")) {
                        annNode = child;
                        continue;
                    }
                    if (child.getNodeName().equalsIgnoreCase("celldesigner:notes")) {
                        notesNode = child;
                        continue;
                    }
                    this.logger.warn("Unknown element of celldesigner:species: " + child.getNodeName());
                }
                if (annNode == null) {
                    this.logger.warn("Included species does not contain annotation node");
                    continue;
                }
                Node spNode = this.getNode("celldesigner:speciesIdentity", annNode.getChildNodes());
                if (spNode != null) {
                    Pair<String, Species> row = parser.parseSpeciesIdentity(spNode);
                    Species sp = row.getRight();
                    sp.setIdSpecies(idIncluded);
                    sp.setName(nameIncluded);
                    this.rap.processNotes(notesNode, (Element)sp, warnings);
                    result.add(row);
                    continue;
                }
                this.logger.warn("No celldesigner:speciesIdentity node in included tag");
                continue;
            }
            this.logger.warn("Unknown element of celldesigner:listOfIncludedSpecies: " + node.getNodeName());
        }
        return result;
    }

    public void addConnectionBetweenIncludedSpecies(Node spieciesNode) {
        NodeList nodes = spieciesNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:species")) {
                String idIncluded = this.getNodeAttr("id", node);
                if (idIncluded == null) {
                    this.logger.warn("Included species does not contain id");
                    continue;
                }
                Node annNode = this.getNode("celldesigner:annotation", node.getChildNodes());
                if (annNode == null) {
                    this.logger.warn("Included species does not contain annotation node");
                    continue;
                }
                Node spNode = this.getNode("celldesigner:complexSpecies", annNode.getChildNodes());
                if (spNode != null) {
                    String idComplex = spNode.getTextContent();
                    ComplexSpecies complex = (ComplexSpecies)this.model.getSpeciesBySpeciesId(idComplex);
                    if (complex == null) {
                        this.logger.warn("Cannot find complex with id: " + idComplex);
                        continue;
                    }
                    Species species = this.model.getSpeciesBySpeciesId(idIncluded);
                    complex.addElement(species);
                    species.setComplex(complex);
                    continue;
                }
                this.logger.warn("No celldesigner:speciesIdentity node in included tag");
                continue;
            }
            this.logger.warn("Unknown element of celldesigner:listOfIncludedSpecies: " + node.getNodeName());
        }
    }

    public String speciesCollectionToXmlIncludedString(Collection<Species> collection) {
        StringBuilder sb = new StringBuilder("");
        sb.append("<celldesigner:listOfIncludedSpecies>\n");
        for (Species species : collection) {
            if (!(species instanceof ComplexSpecies)) continue;
            ComplexSpecies cs = (ComplexSpecies)species;
            for (Element element : cs.getElements()) {
                Species child = (Species)element;
                sb.append("<celldesigner:species id=\"" + child.getIdSpecies() + "\" name=\"" + child.getName() + "\">");
                sb.append("<celldesigner:notes>");
                sb.append("<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><title/></head><body>");
                RestAnnotationParser rap = new RestAnnotationParser();
                sb.append(rap.createAnnotationString(child));
                sb.append(child.getNotes());
                sb.append(this.xap.dataSetToXmlString((Set<MiriamData>)child.getMiriamData()));
                sb.append("</body></html>");
                sb.append("</celldesigner:notes>\n");
                sb.append("<celldesigner:annotation>\n");
                sb.append("<celldesigner:complexSpecies>" + cs.getIdSpecies() + "</celldesigner:complexSpecies>\n");
                sb.append(this.sbmlSpeciesParser.speciesIdentityToXml(child));
                sb.append("</celldesigner:annotation>\n");
                sb.append("</celldesigner:species>\n");
            }
        }
        sb.append("</celldesigner:listOfIncludedSpecies>\n");
        return sb.toString();
    }
}

