/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.species;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.model.map.species.Species;
import org.apache.log4j.Logger;

public class SpeciesCollection<C extends Species> {
    private Logger logger = Logger.getLogger(SpeciesCollection.class.getName());
    private ArrayList<C> allElements = new ArrayList();
    private Map<String, ArrayList<C>> speciesListByLocalId = new HashMap<String, ArrayList<C>>();

    public void add(C element, String localId) {
        try {
            ArrayList<Object> list = this.speciesListByLocalId.get(localId);
            if (list == null) {
                list = new ArrayList();
                this.speciesListByLocalId.put(localId, list);
            }
            list.add(element);
            this.allElements.add(element);
        }
        catch (Exception e) {
            this.logger.error("Unknown error");
            e.printStackTrace();
        }
    }

    public ArrayList<C> getSpeciesListByLocalId(String localId) {
        try {
            ArrayList<C> list = this.speciesListByLocalId.get(localId);
            return list;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public List<String> updateSpeciesByLocalId(C sp, String identifier) {
        ArrayList<String> warnings = new ArrayList<String>();
        Species result = null;
        ArrayList<C> list = this.getSpeciesListByLocalId(identifier);
        if (list == null || list.size() == 0) {
            result = (Species)sp;
            this.add(sp, identifier);
        } else {
            ArrayList<Species> toRemove = new ArrayList<Species>();
            ArrayList<Species> toAdd = new ArrayList<Species>();
            for (Species c : list) {
                Species newInstance;
                List<String> tmpWarnings;
                if (c.getIdSpecies().equals("") || c.getIdSpecies().equals(((Species)sp).getIdSpecies())) {
                    tmpWarnings = c.update((Species)sp);
                    warnings.addAll(tmpWarnings);
                    if (c.getClass() != sp.getClass() && c.getClass().isAssignableFrom(sp.getClass())) {
                        toRemove.add(c);
                        newInstance = this.createNewInstance(sp.getClass(), c);
                        toAdd.add(newInstance);
                        result = newInstance;
                        continue;
                    }
                    result = c;
                    continue;
                }
                if (!((Species)sp).getIdSpecies().equals("")) continue;
                tmpWarnings = c.update((Species)sp);
                warnings.addAll(tmpWarnings);
                if (c.getClass() != sp.getClass() && c.getClass().isAssignableFrom(sp.getClass())) {
                    toRemove.add(c);
                    newInstance = this.createNewInstance(sp.getClass(), c);
                    toAdd.add(newInstance);
                    result = newInstance;
                    continue;
                }
                result = c;
            }
            list.removeAll(toRemove);
            list.addAll(toAdd);
            this.allElements.removeAll(toRemove);
            this.allElements.addAll(toAdd);
            if (result == null) {
                if (((Species)sp).getIdSpecies().equals("")) {
                    throw new InvalidArgumentException("Impossible to update this species - idSpecies is not set, and no other species with custom id were found");
                }
                result = sp;
                this.add(result, identifier);
            }
        }
        return warnings;
    }

    protected C createNewInstance(Class clazz, C c) {
        try {
            return (C)((Species)clazz.getConstructor(Species.class).newInstance(c));
        }
        catch (Exception e) {
            throw new InvalidStateException("Problem with creating object", e);
        }
    }

    public Collection<C> getAll() {
        return this.allElements;
    }

    public void removeSpeciesByLocalId(C sp, String localId) {
        this.allElements.remove(sp);
        this.speciesListByLocalId.get(localId);
    }
}

