/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.species;

import java.util.List;
import lcsb.mapviewer.common.Pair;
import lcsb.mapviewer.converter.model.celldesigner.annotation.RestAnnotationParser;
import lcsb.mapviewer.converter.model.celldesigner.species.AbstractElementXmlParser;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.species.Rna;
import lcsb.mapviewer.model.map.species.fields.RnaRegion;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RnaXmlParser
extends AbstractElementXmlParser<Rna> {
    private Logger logger = Logger.getLogger(RnaXmlParser.class.getName());

    @Override
    public Pair<String, Rna> parseXmlElement(Node rnaNode, List<String> warnings) {
        Rna rna = new Rna();
        String identifier = this.getNodeAttr("id", rnaNode);
        rna.setName(this.getNodeAttr("name", rnaNode));
        NodeList list = rnaNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("celldesigner:notes")) {
                this.getRap().processNotes(node, (Element)rna, warnings);
                continue;
            }
            if (node.getNodeName().equals("celldesigner:listOfRegions")) {
                NodeList residueList = node.getChildNodes();
                for (int j = 0; j < residueList.getLength(); ++j) {
                    Node residueNode = residueList.item(j);
                    if (residueNode.getNodeType() != 1) continue;
                    if (residueNode.getNodeName().equalsIgnoreCase("celldesigner:region")) {
                        rna.addRegion(this.getRnaRegion(residueNode));
                        continue;
                    }
                    this.logger.debug("Unknown element of celldesigner:listOfRegions " + residueNode.getNodeName());
                }
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:rna " + node.getNodeName());
        }
        return new Pair<String, Rna>(identifier, rna);
    }

    private RnaRegion getRnaRegion(Node residueNode) {
        RnaRegion residue = new RnaRegion();
        residue.setIdRnaRegion(this.getNodeAttr("id", residueNode));
        residue.setSize(this.getNodeAttr("size", residueNode));
        residue.setPos(this.getNodeAttr("pos", residueNode));
        residue.setType(this.getNodeAttr("type", residueNode));
        NodeList list = residueNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            this.logger.debug("Unknown element of celldesigner:region " + node.getNodeName());
        }
        return residue;
    }

    @Override
    public String toXml(Rna rna) {
        String attributes = "";
        String result = "";
        attributes = attributes + " id=\"r_" + rna.getIdSpecies() + "\"";
        if (!rna.getName().equals("")) {
            attributes = attributes + " name=\"" + this.escapeXml(rna.getName()) + "\"";
        }
        result = result + "<celldesigner:RNA" + attributes + ">";
        result = result + "<celldesigner:notes>";
        result = result + "<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><title/></head><body>";
        RestAnnotationParser rap = new RestAnnotationParser();
        result = result + rap.createAnnotationString(rna);
        result = result + rna.getNotes();
        result = result + "</body></html>";
        result = result + "</celldesigner:notes>";
        result = result + "</celldesigner:RNA>";
        return result;
    }
}

