/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.species;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lcsb.mapviewer.common.Pair;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.converter.model.celldesigner.species.SpeciesCollection;
import lcsb.mapviewer.model.map.species.AntisenseRna;
import lcsb.mapviewer.model.map.species.ComplexSpecies;
import lcsb.mapviewer.model.map.species.Degraded;
import lcsb.mapviewer.model.map.species.Drug;
import lcsb.mapviewer.model.map.species.Gene;
import lcsb.mapviewer.model.map.species.Ion;
import lcsb.mapviewer.model.map.species.Phenotype;
import lcsb.mapviewer.model.map.species.Protein;
import lcsb.mapviewer.model.map.species.Rna;
import lcsb.mapviewer.model.map.species.SimpleMolecule;
import lcsb.mapviewer.model.map.species.Species;
import lcsb.mapviewer.model.map.species.Unknown;

public class InternalModelSpeciesData {
    private SpeciesCollection<Protein> proteins;
    private SpeciesCollection<Gene> genes;
    private SpeciesCollection<Rna> rnas;
    private SpeciesCollection<AntisenseRna> antisenseRnas;
    private SpeciesCollection<Phenotype> phenotypes;
    private SpeciesCollection<Ion> ions;
    private SpeciesCollection<SimpleMolecule> simpleMolecules;
    private SpeciesCollection<Drug> drugs;
    private SpeciesCollection<Unknown> unknowns;
    private SpeciesCollection<Degraded> degradeds;
    private List<ComplexSpecies> complexes = new ArrayList<ComplexSpecies>();

    public InternalModelSpeciesData() {
        this.proteins = new SpeciesCollection();
        this.genes = new SpeciesCollection();
        this.rnas = new SpeciesCollection();
        this.antisenseRnas = new SpeciesCollection();
        this.phenotypes = new SpeciesCollection();
        this.ions = new SpeciesCollection();
        this.simpleMolecules = new SpeciesCollection();
        this.drugs = new SpeciesCollection();
        this.unknowns = new SpeciesCollection();
        this.degradeds = new SpeciesCollection();
    }

    public Collection<Protein> getProteins() {
        return this.proteins.getAll();
    }

    public Collection<Gene> getGenes() {
        return this.genes.getAll();
    }

    public Collection<Rna> getRnas() {
        return this.rnas.getAll();
    }

    public Collection<AntisenseRna> getAntisenseRnas() {
        return this.antisenseRnas.getAll();
    }

    public List<String> updateSpecies(Collection<Pair<String, ? extends Species>> collection) {
        ArrayList<String> warnings = new ArrayList<String>();
        for (Pair<String, ? extends Species> species : collection) {
            List<String> tmpWarnings = this.updateSpecies(species.getRight(), species.getLeft());
            warnings.addAll(tmpWarnings);
        }
        return warnings;
    }

    public List<String> updateSpecies(Species sp, String identifier) {
        ArrayList<String> warnings = new ArrayList<String>();
        if (sp instanceof Gene) {
            warnings.addAll(this.genes.updateSpeciesByLocalId((Gene)sp, identifier));
        } else if (sp instanceof Protein) {
            warnings.addAll(this.proteins.updateSpeciesByLocalId((Protein)sp, identifier));
        } else if (sp instanceof Rna) {
            warnings.addAll(this.rnas.updateSpeciesByLocalId((Rna)sp, identifier));
        } else if (sp instanceof AntisenseRna) {
            warnings.addAll(this.antisenseRnas.updateSpeciesByLocalId((AntisenseRna)sp, identifier));
        } else if (sp instanceof Degraded) {
            warnings.addAll(this.degradeds.updateSpeciesByLocalId((Degraded)sp, identifier));
        } else if (sp instanceof Unknown) {
            warnings.addAll(this.unknowns.updateSpeciesByLocalId((Unknown)sp, identifier));
        } else if (sp instanceof Drug) {
            warnings.addAll(this.drugs.updateSpeciesByLocalId((Drug)sp, identifier));
        } else if (sp instanceof SimpleMolecule) {
            warnings.addAll(this.simpleMolecules.updateSpeciesByLocalId((SimpleMolecule)sp, identifier));
        } else if (sp instanceof Ion) {
            warnings.addAll(this.ions.updateSpeciesByLocalId((Ion)sp, identifier));
        } else if (sp instanceof Phenotype) {
            warnings.addAll(this.phenotypes.updateSpeciesByLocalId((Phenotype)sp, identifier));
        } else if (sp instanceof ComplexSpecies) {
            this.complexes.add((ComplexSpecies)sp);
        } else {
            throw new InvalidArgumentException("Unknown species type: " + sp.getClass().getName());
        }
        return warnings;
    }

    public Collection<Species> getAll() {
        ArrayList<Species> result = new ArrayList<Species>();
        result.addAll(this.genes.getAll());
        result.addAll(this.rnas.getAll());
        result.addAll(this.antisenseRnas.getAll());
        result.addAll(this.phenotypes.getAll());
        result.addAll(this.ions.getAll());
        result.addAll(this.simpleMolecules.getAll());
        result.addAll(this.drugs.getAll());
        result.addAll(this.unknowns.getAll());
        result.addAll(this.degradeds.getAll());
        result.addAll(this.proteins.getAll());
        result.addAll(this.complexes);
        return result;
    }
}

