/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.species;

import java.util.List;
import lcsb.mapviewer.common.Pair;
import lcsb.mapviewer.common.exception.InvalidXmlSchemaException;
import lcsb.mapviewer.converter.model.celldesigner.annotation.RestAnnotationParser;
import lcsb.mapviewer.converter.model.celldesigner.species.AbstractElementXmlParser;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.species.Gene;
import lcsb.mapviewer.model.map.species.fields.ModificationResidue;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GeneXmlParser
extends AbstractElementXmlParser<Gene> {
    private Logger logger = Logger.getLogger(GeneXmlParser.class.getName());

    @Override
    public Pair<String, Gene> parseXmlElement(Node geneNode, List<String> warnings) throws InvalidXmlSchemaException {
        Gene gene = new Gene();
        String identifier = this.getNodeAttr("id", geneNode);
        gene.setName(this.getNodeAttr("name", geneNode));
        NodeList list = geneNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("celldesigner:notes")) {
                this.getRap().processNotes(node, (Element)gene, warnings);
                continue;
            }
            if (node.getNodeName().equals("celldesigner:listOfRegions")) {
                NodeList residueList = node.getChildNodes();
                for (int j = 0; j < residueList.getLength(); ++j) {
                    Node residueNode = residueList.item(j);
                    if (residueNode.getNodeType() != 1) continue;
                    if (residueNode.getNodeName().equalsIgnoreCase("celldesigner:region")) {
                        gene.addModificationResidue(this.getModificationResidue(residueNode));
                        continue;
                    }
                    this.logger.debug("Unknown element of celldesigner:listOfRegions " + residueNode.getNodeName());
                }
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:gene " + node.getNodeName());
        }
        return new Pair<String, Gene>(identifier, gene);
    }

    private ModificationResidue getModificationResidue(Node residueNode) {
        ModificationResidue residue = new ModificationResidue();
        residue.setIdModificationResidue(this.getNodeAttr("id", residueNode));
        residue.setName(this.getNodeAttr("name", residueNode));
        residue.setSide(this.getNodeAttr("side", residueNode));
        residue.setAngle(this.getNodeAttr("pos", residueNode));
        NodeList list = residueNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            this.logger.debug("Unknown element of celldesigner:region " + node.getNodeName());
        }
        return residue;
    }

    @Override
    public String toXml(Gene gene) {
        String attributes = "";
        String result = "";
        attributes = attributes + " id=\"g_" + gene.getIdSpecies() + "\"";
        if (!gene.getName().equals("")) {
            attributes = attributes + " name=\"" + this.escapeXml(gene.getName()) + "\"";
        }
        result = result + "<celldesigner:gene" + attributes + ">";
        result = result + "<celldesigner:notes>";
        result = result + "<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><title/></head><body>";
        RestAnnotationParser rap = new RestAnnotationParser();
        result = result + rap.createAnnotationString(gene);
        result = result + gene.getNotes();
        result = result + "</body></html>";
        result = result + "</celldesigner:notes>";
        result = result + "</celldesigner:gene>";
        return result;
    }
}

