/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.reaction;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lcsb.mapviewer.common.XmlParser;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.converter.model.celldesigner.annotation.XmlAnnotationParser;
import lcsb.mapviewer.converter.model.celldesigner.geometry.CellDesignerAliasConverter;
import lcsb.mapviewer.converter.model.celldesigner.geometry.helper.CellDesignerAnchor;
import lcsb.mapviewer.converter.model.celldesigner.geometry.helper.CellDesignerLineTransformation;
import lcsb.mapviewer.converter.model.celldesigner.geometry.helper.CellDesignerPointTransformation;
import lcsb.mapviewer.converter.model.celldesigner.reaction.ReactionLineData;
import lcsb.mapviewer.converter.model.celldesigner.types.ModifierType;
import lcsb.mapviewer.converter.model.celldesigner.types.ModifierTypeUtils;
import lcsb.mapviewer.converter.model.celldesigner.types.OperatorTypeUtils;
import lcsb.mapviewer.model.graphics.PolylineData;
import lcsb.mapviewer.model.map.MiriamData;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import lcsb.mapviewer.model.map.layout.alias.ComplexAlias;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAlias;
import lcsb.mapviewer.model.map.reaction.AbstractNode;
import lcsb.mapviewer.model.map.reaction.Modifier;
import lcsb.mapviewer.model.map.reaction.NodeOperator;
import lcsb.mapviewer.model.map.reaction.Product;
import lcsb.mapviewer.model.map.reaction.Reactant;
import lcsb.mapviewer.model.map.reaction.Reaction;
import lcsb.mapviewer.model.map.reaction.type.SimpleReactionInterface;
import lcsb.mapviewer.model.map.reaction.type.TwoProductReactionInterface;
import lcsb.mapviewer.model.map.reaction.type.TwoReactantReactionInterface;
import lcsb.mapviewer.model.map.species.Species;
import org.apache.log4j.Logger;

public class ReactionToXml
extends XmlParser {
    private static Logger logger = Logger.getLogger(ReactionToXml.class);
    private CellDesignerPointTransformation pointTransformation = new CellDesignerPointTransformation();
    private CellDesignerLineTransformation lineTransformation = new CellDesignerLineTransformation();

    public String toXml(Reaction reaction) {
        StringBuilder sb = new StringBuilder();
        sb.append("<reaction ");
        sb.append("metaid=\"" + reaction.getMetaId() + "\" ");
        sb.append("id=\"" + reaction.getIdReaction() + "\" ");
        sb.append("name=\"" + reaction.getName() + "\" ");
        sb.append("reversible=\"" + reaction.isReversible() + "\" ");
        sb.append(">\n");
        if (reaction.getNotes() != null && !reaction.getNotes().equals("")) {
            sb.append("<notes>");
            sb.append("<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><title/></head><body>");
            sb.append(reaction.getNotes());
            sb.append("</body></html>");
            sb.append("</notes>");
        }
        sb.append(this.getAnnotationXmlStringForReaction(reaction));
        sb.append(this.getListOfReactantsXmlStringForReaction(reaction));
        sb.append(this.getListOfProductsXmlStringForReaction(reaction));
        sb.append(this.getSbmlListOfModificationsXmlStringForReaction(reaction));
        sb.append("</reaction>\n");
        return sb.toString();
    }

    private String getListOfModificationsXmlStringForReaction(Reaction reaction) {
        StringBuilder sb = new StringBuilder();
        sb.append("<celldesigner:listOfModification>\n");
        HashMap<Modifier, NodeOperator> operators = new HashMap<Modifier, NodeOperator>();
        HashSet<NodeOperator> usedOperators = new HashSet<NodeOperator>();
        for (NodeOperator node : reaction.getOperators()) {
            if (!node.isModifierOperator()) continue;
            for (AbstractNode modNode : node.getInputs()) {
                Modifier modifier = (Modifier)modNode;
                operators.put(modifier, node);
            }
        }
        for (Modifier modifier : reaction.getModifiers()) {
            NodeOperator node = (NodeOperator)operators.get(modifier);
            if (node != null && !usedOperators.contains(node)) {
                usedOperators.add(node);
                sb.append(this.getModifierXmlString(node));
            }
            sb.append(this.getModifierXmlString(modifier, node));
        }
        sb.append("</celldesigner:listOfModification>\n");
        return sb.toString();
    }

    private String getSbmlListOfModificationsXmlStringForReaction(Reaction reaction) {
        if (reaction.getModifiers().size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<listOfModifiers>\n");
        for (Modifier modifier : reaction.getModifiers()) {
            sb.append(this.getModifierReferenceXmlString(modifier));
        }
        sb.append("</listOfModifiers>\n");
        return sb.toString();
    }

    private String getModifierReferenceXmlString(Modifier modifier) {
        StringBuilder sb = new StringBuilder();
        sb.append("<modifierSpeciesReference ");
        Species species = (Species)modifier.getElement();
        sb.append("metaid=\"" + species.getMetaId() + "\" ");
        String speciesId = species.getIdSpecies();
        List<SpeciesAlias> aliases = species.getModelData().getModel().getAliasesBySpeciesId(species.getIdSpecies());
        SpeciesAlias alias = aliases.get(0);
        while (alias.getParent() instanceof ComplexAlias) {
            alias = (ComplexAlias)alias.getParent();
        }
        speciesId = alias.getSpecies().getIdSpecies();
        sb.append("species=\"" + speciesId + "\">\n");
        sb.append("<annotation>\n");
        sb.append("<celldesigner:extension>\n");
        sb.append("<celldesigner:alias>" + modifier.getAlias().getAliasId() + "</celldesigner:alias>\n");
        sb.append("</celldesigner:extension>\n");
        sb.append("</annotation>\n");
        sb.append("</modifierSpeciesReference>\n");
        return sb.toString();
    }

    private String getModifierXmlString(NodeOperator modifierOperator) {
        StringBuilder sb = new StringBuilder();
        OperatorTypeUtils otu = new OperatorTypeUtils();
        ModifierTypeUtils mtu = new ModifierTypeUtils();
        ModifierType modifierType = mtu.getModifierTypeForOperator(modifierOperator);
        sb.append("<celldesigner:modification ");
        String type = otu.getStringTypeByOperator(modifierOperator);
        sb.append(" type=\"" + type + "\" ");
        sb.append(" modificationType=\"" + modifierType.getStringName() + "\" ");
        String modifiers = "";
        String aliases = "";
        for (AbstractNode modifier : modifierOperator.getInputs()) {
            if (!(modifier instanceof Modifier)) continue;
            Modifier mod = (Modifier)modifier;
            if (modifiers.equals("")) {
                modifiers = ((Species)mod.getElement()).getIdSpecies();
                aliases = mod.getAlias().getAliasId();
                continue;
            }
            modifiers = modifiers + "," + ((Species)mod.getElement()).getIdSpecies();
            aliases = aliases + "," + mod.getAlias().getAliasId();
        }
        sb.append(" modifiers=\"" + modifiers + "\" ");
        sb.append(" aliases=\"" + aliases + "\" ");
        sb.append(" targetLineIndex=\"" + mtu.getTargetLineIndexByModifier(modifierOperator) + "\" ");
        PolylineData line = new PolylineData(modifierOperator.getLine());
        line.trimEnd(-modifierType.getTrimLength());
        line = line.reverse();
        List<Point2D> points = this.lineTransformation.getPointsFromLine(line);
        sb.append(" editPoints=\"");
        for (int i = 1; i < points.size() - 1; ++i) {
            sb.append(points.get(i).getX() + "," + points.get(i).getY() + " ");
        }
        sb.append(line.getEndPoint().getX() + "," + line.getEndPoint().getY());
        sb.append("\"");
        sb.append(">\n");
        PolylineData[] lines = new PolylineData[]{modifierOperator.getLine()};
        sb.append(this.getConnectSchemeXmlStringForLines(lines, null));
        sb.append("<celldesigner:line ");
        sb.append("width=\"" + modifierOperator.getLine().getWidth() + "\" ");
        sb.append("color=\"" + this.colorToString(modifierOperator.getLine().getColor()) + "\" ");
        sb.append("type=\"Straight\" ");
        sb.append("/>\n");
        sb.append("</celldesigner:modification>\n");
        return sb.toString();
    }

    private String getModifierXmlString(Modifier modifier, NodeOperator gate) {
        List<Point2D> points;
        StringBuilder sb = new StringBuilder();
        ModifierTypeUtils modifierTypeUtils = new ModifierTypeUtils();
        sb.append("<celldesigner:modification ");
        String type = modifierTypeUtils.getStringTypeByModifier(modifier);
        sb.append(" type=\"" + type + "\" ");
        Species species = (Species)modifier.getElement();
        sb.append(" modifiers=\"" + species.getIdSpecies() + "\" ");
        sb.append(" aliases=\"" + modifier.getAlias().getAliasId() + "\" ");
        sb.append(" targetLineIndex=\"" + modifierTypeUtils.getTargetLineIndexByModifier(modifier) + "\" ");
        PolylineData line = new PolylineData(modifier.getLine());
        line.trimEnd(-modifierTypeUtils.getModifierTypeForClazz(modifier.getClass()).getTrimLength());
        if (gate != null) {
            line.setEndPoint(gate.getLine().getBeginPoint());
            CellDesignerAliasConverter converter = new CellDesignerAliasConverter(modifier.getAlias());
            CellDesignerAnchor anchor = converter.getAnchorForCoordinates(modifier.getAlias(), line.getBeginPoint());
            Point2D start = converter.getPointCoordinates(modifier.getAlias(), anchor);
            line.setStartPoint(start);
        }
        if ((points = this.lineTransformation.getPointsFromLine(line)).size() > 0) {
            boolean first = true;
            sb.append(" editPoints=\"");
            for (Point2D point : points) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" ");
                }
                sb.append(point.getX() + "," + point.getY());
            }
            sb.append("\"");
        }
        sb.append(">\n");
        PolylineData[] lines = new PolylineData[]{modifier.getLine()};
        sb.append(this.getConnectSchemeXmlStringForLines(lines, null));
        sb.append(this.getLinkTargetXmlString(modifier));
        sb.append("<celldesigner:line ");
        sb.append("width=\"" + modifier.getLine().getWidth() + "\" ");
        sb.append("color=\"" + this.colorToString(modifier.getLine().getColor()) + "\" ");
        sb.append("type=\"Straight\" ");
        sb.append("/>\n");
        sb.append("</celldesigner:modification>\n");
        return sb.toString();
    }

    private String getLinkTargetXmlString(Modifier modifier) {
        StringBuilder sb = new StringBuilder();
        Species species = (Species)modifier.getElement();
        sb.append("<celldesigner:linkTarget species=\"" + species.getIdSpecies() + "\" alias=\"" + modifier.getAlias().getAliasId() + "\">\n");
        sb.append(this.getAnchorXml(modifier.getAlias(), modifier.getLine().getBeginPoint()));
        sb.append("</celldesigner:linkTarget>\n");
        return sb.toString();
    }

    private String getListOfProductsXmlStringForReaction(Reaction reaction) {
        StringBuilder sb = new StringBuilder();
        sb.append("<listOfProducts>\n");
        for (Product product : reaction.getProducts()) {
            Species species = (Species)product.getElement();
            String speciesId = species.getIdSpecies();
            List<SpeciesAlias> aliases = species.getModelData().getModel().getAliasesBySpeciesId(species.getIdSpecies());
            SpeciesAlias alias = aliases.get(0);
            while (alias.getParent() instanceof ComplexAlias) {
                alias = (ComplexAlias)alias.getParent();
            }
            speciesId = alias.getSpecies().getIdSpecies();
            sb.append("<speciesReference species=\"" + speciesId + "\">\n");
            sb.append("<annotation>\n");
            sb.append("<celldesigner:extension>\n");
            sb.append("<celldesigner:alias>" + product.getAlias().getAliasId() + "</celldesigner:alias>\n");
            sb.append("</celldesigner:extension>\n");
            sb.append("</annotation>\n");
            sb.append("</speciesReference>\n");
        }
        sb.append("</listOfProducts>\n");
        return sb.toString();
    }

    private String getListOfReactantsXmlStringForReaction(Reaction reaction) {
        StringBuilder sb = new StringBuilder();
        sb.append("<listOfReactants>\n");
        for (Reactant reactant : reaction.getReactants()) {
            sb.append("<speciesReference species=\"" + ((Species)reactant.getElement()).getIdSpecies() + "\">\n");
            sb.append("<annotation>\n");
            sb.append("<celldesigner:extension>\n");
            sb.append("<celldesigner:alias>" + reactant.getAlias().getAliasId() + "</celldesigner:alias>\n");
            sb.append("</celldesigner:extension>\n");
            sb.append("</annotation>\n");
            sb.append("</speciesReference>\n");
        }
        sb.append("</listOfReactants>\n");
        return sb.toString();
    }

    private String getAnnotationXmlStringForReaction(Reaction reaction) {
        ReactionLineData rdl = ReactionLineData.getByReactionType(reaction.getClass());
        if (rdl == null) {
            throw new InvalidArgumentException("Unknown reaction type: " + reaction.getClass());
        }
        String reactionClassString = rdl.getCellDesignerString();
        StringBuilder sb = new StringBuilder();
        sb.append("<annotation>\n");
        sb.append("<celldesigner:extension>\n");
        sb.append("<celldesigner:reactionType>" + reactionClassString + "</celldesigner:reactionType>");
        sb.append(this.getBaseReactantsXmlStringForReaction(reaction));
        sb.append(this.getBaseProductsXmlStringForReaction(reaction));
        sb.append(this.getListOfReactantLinksXmlStringForReaction(reaction));
        sb.append(this.getListOfProductLinksXmlStringForReaction(reaction));
        sb.append(this.getConnectSchemeXmlStringForReaction(reaction));
        sb.append(this.getEditPointsXmlStringForReaction(reaction));
        sb.append(this.getListOfModificationsXmlStringForReaction(reaction));
        sb.append("<celldesigner:line ");
        sb.append("width=\"" + reaction.getReactants().get(0).getLine().getWidth() + "\" ");
        sb.append("color=\"" + this.colorToString(reaction.getReactants().get(0).getLine().getColor()) + "\" ");
        sb.append("type=\"Straight\" ");
        sb.append("/>\n");
        XmlAnnotationParser xmlAnnotationParser = new XmlAnnotationParser();
        sb.append("</celldesigner:extension>\n");
        sb.append(xmlAnnotationParser.dataSetToXmlString((Set<MiriamData>)reaction.getMiriamData()));
        sb.append("</annotation>\n");
        return sb.toString();
    }

    private String getListOfProductLinksXmlStringForReaction(Reaction reaction) {
        StringBuilder sb = new StringBuilder();
        sb.append("<celldesigner:listOfProductLinks>\n");
        int firstElement = 1;
        if (reaction instanceof TwoProductReactionInterface) {
            firstElement = 2;
        }
        for (int i = firstElement; i < reaction.getProducts().size(); ++i) {
            sb.append(this.getProductLinkXmlString(reaction.getProducts().get(i)));
        }
        sb.append("</celldesigner:listOfProductLinks>\n");
        return sb.toString();
    }

    private String getListOfReactantLinksXmlStringForReaction(Reaction reaction) {
        StringBuilder sb = new StringBuilder();
        sb.append("<celldesigner:listOfReactantLinks>\n");
        int firstElement = 1;
        if (reaction instanceof TwoReactantReactionInterface) {
            firstElement = 2;
        }
        for (int i = firstElement; i < reaction.getReactants().size(); ++i) {
            sb.append(this.getReactantLinkXmlString(reaction.getReactants().get(i)));
        }
        sb.append("</celldesigner:listOfReactantLinks>\n");
        return sb.toString();
    }

    private String getReactantLinkXmlString(Reactant reactant) {
        Alias alias = reactant.getAlias();
        StringBuilder sb = new StringBuilder();
        sb.append("<celldesigner:reactantLink ");
        sb.append("reactant=\"" + ((Species)reactant.getElement()).getIdSpecies() + "\" ");
        sb.append("alias=\"" + alias.getAliasId() + "\" ");
        sb.append(">\n");
        sb.append(this.getAnchorXml(alias, reactant.getLine().getBeginPoint()));
        sb.append("<celldesigner:connectScheme connectPolicy=\"direct\">\n");
        sb.append("<celldesigner:listOfLineDirection>\n");
        for (int i = 0; i < reactant.getLine().getPoints().size() - 1; ++i) {
            sb.append("<celldesigner:lineDirection index=\"" + i + "\" value=\"unknown\"/>\n");
        }
        sb.append("</celldesigner:listOfLineDirection>\n");
        sb.append("</celldesigner:connectScheme>\n");
        sb.append(this.getEditPointsXmlStringForLine(new PolylineData[]{reactant.getLine()}, 0));
        sb.append("<celldesigner:line ");
        sb.append("width=\"" + reactant.getLine().getWidth() + "\" ");
        sb.append("color=\"" + this.colorToString(reactant.getLine().getColor()) + "\" ");
        sb.append("type=\"Straight\" ");
        sb.append("/>\n");
        sb.append("</celldesigner:reactantLink>");
        return sb.toString();
    }

    private String getProductLinkXmlString(Product product) {
        Alias alias = product.getAlias();
        PolylineData[] lines = new PolylineData[]{product.getLine()};
        StringBuilder sb = new StringBuilder();
        sb.append("<celldesigner:productLink ");
        sb.append("product=\"" + ((Species)product.getElement()).getIdSpecies() + "\" ");
        sb.append("alias=\"" + alias.getAliasId() + "\" ");
        sb.append(">\n");
        sb.append(this.getAnchorXml(alias, product.getLine().getEndPoint()));
        sb.append(this.getConnectSchemeXmlStringForLines(lines, null));
        sb.append(this.getEditPointsXmlStringForLine(lines, 0));
        sb.append("<celldesigner:line ");
        sb.append("width=\"" + product.getLine().getWidth() + "\" ");
        sb.append("color=\"" + this.colorToString(product.getLine().getColor()) + "\" ");
        sb.append("type=\"Straight\" ");
        sb.append("/>\n");
        sb.append("</celldesigner:productLink>");
        return sb.toString();
    }

    private String getConnectSchemeXmlStringForLines(PolylineData[] lines, Integer rectangleIndex) {
        StringBuilder sb = new StringBuilder();
        sb.append("<celldesigner:connectScheme ");
        sb.append("connectPolicy=\"direct\" ");
        if (rectangleIndex != null) {
            sb.append("rectangleIndex=\"" + rectangleIndex + "\" ");
        }
        sb.append(">\n");
        sb.append("<celldesigner:listOfLineDirection>\n");
        int armId = 0;
        for (PolylineData line : lines) {
            String arm = "";
            if (lines.length > 1) {
                arm = " arm\"" + armId + "\" ";
                ++armId;
            }
            for (int i = 0; i < line.getPoints().size() - 1; ++i) {
                sb.append("<celldesigner:lineDirection " + arm + " index=\"" + i + "\" value=\"unknown\"/>\n");
            }
        }
        sb.append("</celldesigner:listOfLineDirection>\n");
        sb.append("</celldesigner:connectScheme>\n");
        return sb.toString();
    }

    private String getEditPointsXmlStringForLine(PolylineData[] lines, Integer centerIndex) {
        return this.getEditPointsXmlStringForLine(lines, null, centerIndex);
    }

    private String getEditPointsXmlStringForLine(PolylineData[] lines, Point2D centerPoint, Integer centerIndex) {
        StringBuilder sb = new StringBuilder();
        sb.append("<celldesigner:editPoints ");
        if (lines.length > 1) {
            for (int i = 0; i < lines.length; ++i) {
                sb.append(" num" + i + "=\"" + (lines[i].getPoints().size() - 2) + "\" ");
            }
            if (centerIndex != null) {
                sb.append(" tShapeIndex=\"" + centerIndex + "\"");
            }
        }
        sb.append(">");
        boolean first = true;
        for (PolylineData pd : lines) {
            List<Point2D> points = this.lineTransformation.getPointsFromLine(pd);
            for (Point2D point : points) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" ");
                }
                sb.append(point.getX() + "," + point.getY());
            }
        }
        if (centerPoint != null) {
            sb.append(" " + centerPoint.getX() + "," + centerPoint.getY());
        }
        sb.append("</celldesigner:editPoints>\n");
        if (first && centerPoint == null) {
            return "";
        }
        return sb.toString();
    }

    private String getEditPointsXmlStringForReaction(Reaction reaction) {
        if (reaction instanceof SimpleReactionInterface) {
            int i;
            Product product = reaction.getProducts().get(0);
            Reactant reactant = reaction.getReactants().get(0);
            ArrayList<Point2D> points = new ArrayList<Point2D>();
            for (i = 0; i < reactant.getLine().getPoints().size() - 1; ++i) {
                points.add(reactant.getLine().getPoints().get(i));
            }
            for (i = 1; i < product.getLine().getPoints().size(); ++i) {
                points.add(product.getLine().getPoints().get(i));
            }
            PolylineData pd = new PolylineData(points);
            return this.getEditPointsXmlStringForLine(new PolylineData[]{pd}, reactant.getLine().getPoints().size() - 1);
        }
        if (reaction instanceof TwoReactantReactionInterface) {
            Reactant reactant1 = reaction.getReactants().get(0);
            Reactant reactant2 = reaction.getReactants().get(1);
            PolylineData line1 = reactant1.getLine();
            PolylineData line2 = reactant2.getLine();
            ArrayList<Point2D> points = new ArrayList<Point2D>();
            for (NodeOperator operator : reaction.getOperators()) {
                if (!operator.isReactantOperator()) continue;
                boolean process = true;
                for (AbstractNode node : operator.getInputs()) {
                    if (node instanceof Reactant) continue;
                    process = false;
                }
                if (!process) continue;
                for (int i = 0; i < operator.getLine().getPoints().size() - 1; ++i) {
                    points.add(operator.getLine().getPoints().get(i));
                }
            }
            Product product = reaction.getProducts().get(0);
            for (int i = 1; i < product.getLine().getPoints().size(); ++i) {
                points.add(product.getLine().getPoints().get(i));
            }
            Point2D endPoint = (Point2D)points.get(points.size() - 1);
            CellDesignerAliasConverter converter = new CellDesignerAliasConverter(product.getAlias());
            CellDesignerAnchor anchor = converter.getAnchorForCoordinates(product.getAlias(), endPoint);
            if (anchor == null) {
                points.set(points.size() - 1, product.getAlias().getCenter());
            }
            PolylineData line3 = new PolylineData(points);
            Point2D pointC = reactant1.getAlias().getCenter();
            Point2D pointA = reactant2.getAlias().getCenter();
            Point2D pointB = product.getAlias().getCenter();
            Point2D pointO = line3.getBeginPoint();
            Point2D centerPoint = this.pointTransformation.getCoordinatesInCellDesignerBase(pointA, pointB, pointC, pointO);
            return this.getEditPointsXmlStringForLine(new PolylineData[]{line1.reverse(), line2.reverse(), line3.reverse().reverse()}, centerPoint, line3.getPoints().size() - product.getLine().getPoints().size());
        }
        if (reaction instanceof TwoProductReactionInterface) {
            ArrayList<Point2D> points = new ArrayList<Point2D>();
            Reactant reactant = reaction.getReactants().get(0);
            Product product1 = reaction.getProducts().get(0);
            Product product2 = reaction.getProducts().get(1);
            for (int i = 0; i < reactant.getLine().getPoints().size() - 1; ++i) {
                points.add(reactant.getLine().getPoints().get(i));
            }
            Point2D startPoint = (Point2D)points.get(0);
            CellDesignerAliasConverter converter = new CellDesignerAliasConverter(reactant.getAlias());
            CellDesignerAnchor anchor = converter.getAnchorForCoordinates(reactant.getAlias(), startPoint);
            if (anchor == null) {
                points.set(points.size() - 1, reactant.getAlias().getCenter());
            }
            int index = points.size();
            for (NodeOperator operator : reaction.getOperators()) {
                if (!operator.isProductOperator()) continue;
                boolean process = true;
                for (AbstractNode node : operator.getOutputs()) {
                    if (node instanceof Product) continue;
                    process = false;
                }
                if (!process) continue;
                for (int i = operator.getLine().getPoints().size() - 2; i >= 0; --i) {
                    points.add(operator.getLine().getPoints().get(i));
                }
            }
            index = points.size() - index - 1;
            PolylineData line1 = new PolylineData(points);
            PolylineData line2 = product1.getLine();
            PolylineData line3 = product2.getLine();
            Point2D pointA = product1.getAlias().getCenter();
            Point2D pointB = product2.getAlias().getCenter();
            Point2D pointC = reactant.getAlias().getCenter();
            Point2D pointO = line2.getBeginPoint();
            Point2D centerPoint = this.pointTransformation.getCoordinatesInCellDesignerBase(pointA, pointB, pointC, pointO);
            return this.getEditPointsXmlStringForLine(new PolylineData[]{line1.reverse(), line2, line3}, centerPoint, index);
        }
        logger.warn("Unhandled reaction type: " + reaction.getClass());
        return null;
    }

    private String getConnectSchemeXmlStringForReaction(Reaction reaction) {
        StringBuilder sb = new StringBuilder();
        sb.append("<celldesigner:connectScheme ");
        sb.append("connectPolicy=\"direct\" ");
        int rectangleIndex = -1;
        if (reaction instanceof SimpleReactionInterface) {
            rectangleIndex = reaction.getReactants().get(0).getLine().getPoints().size() - 2;
            sb.append("rectangleIndex=\"" + rectangleIndex + "\" ");
        }
        sb.append(">\n");
        sb.append("<celldesigner:listOfLineDirection>\n");
        if (reaction instanceof SimpleReactionInterface) {
            int size = reaction.getReactants().get(0).getLine().getPoints().size() + reaction.getProducts().get(0).getLine().getPoints().size() - 2 - 1;
            for (int i = 0; i < size; ++i) {
                sb.append("<celldesigner:lineDirection index=\"" + i + "\" value=\"unknown\"/>\n");
            }
        } else if (reaction instanceof TwoProductReactionInterface || reaction instanceof TwoReactantReactionInterface) {
            int i;
            String string = this.getEditPointsXmlStringForReaction(reaction);
            Pattern p0 = Pattern.compile("num0=\"([0-9]+)");
            Pattern p1 = Pattern.compile("num1=\"([0-9]+)");
            Pattern p2 = Pattern.compile("num2=\"([0-9]+)");
            Matcher m0 = p0.matcher(string);
            Matcher m1 = p1.matcher(string);
            Matcher m2 = p2.matcher(string);
            int num0 = 0;
            int num1 = 0;
            int num2 = 0;
            if (!(m0.find() && m1.find() && m2.find())) {
                logger.error("Invalid editPoints string" + string);
                return null;
            }
            num0 = Integer.parseInt(m0.group(1));
            num1 = Integer.parseInt(m1.group(1));
            num2 = Integer.parseInt(m2.group(1));
            for (i = 0; i <= num0; ++i) {
                sb.append("<celldesigner:lineDirection arm=\"0\" index=\"" + i + "\" value=\"unknown\"/>\n");
            }
            for (i = 0; i <= num1; ++i) {
                sb.append("<celldesigner:lineDirection arm=\"1\" index=\"" + i + "\" value=\"unknown\"/>\n");
            }
            for (i = 0; i <= num2; ++i) {
                sb.append("<celldesigner:lineDirection arm=\"2\" index=\"" + i + "\" value=\"unknown\"/>\n");
            }
        } else {
            logger.warn("Unknown reaction type: " + reaction.getClass());
        }
        sb.append("</celldesigner:listOfLineDirection>\n");
        sb.append("</celldesigner:connectScheme>\n");
        return sb.toString();
    }

    private String getBaseProductsXmlStringForReaction(Reaction reaction) {
        ArrayList<Product> products = new ArrayList<Product>();
        products.add(reaction.getProducts().get(0));
        if (reaction instanceof TwoProductReactionInterface) {
            products.add(reaction.getProducts().get(1));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<celldesigner:baseProducts>\n");
        for (Product product : products) {
            Species species = (Species)product.getElement();
            Alias alias = product.getAlias();
            sb.append("<celldesigner:baseProduct ");
            sb.append("species=\"" + species.getIdSpecies() + "\" ");
            sb.append("alias=\"" + product.getAlias().getAliasId() + "\" ");
            sb.append(">\n");
            sb.append(this.getAnchorXml(alias, product.getLine().getEndPoint()));
            sb.append("</celldesigner:baseProduct>\n");
        }
        sb.append("</celldesigner:baseProducts>\n");
        return sb.toString();
    }

    private String getBaseReactantsXmlStringForReaction(Reaction reaction) {
        ArrayList<Reactant> reactants = new ArrayList<Reactant>();
        reactants.add(reaction.getReactants().get(0));
        if (reaction instanceof TwoReactantReactionInterface) {
            reactants.add(reaction.getReactants().get(1));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<celldesigner:baseReactants>\n");
        for (Reactant reactant : reactants) {
            Species species = (Species)reactant.getElement();
            Alias alias = reactant.getAlias();
            sb.append("<celldesigner:baseReactant ");
            sb.append("species=\"" + species.getIdSpecies() + "\" ");
            sb.append("alias=\"" + reactant.getAlias().getAliasId() + "\" ");
            sb.append(">\n");
            sb.append(this.getAnchorXml(alias, reactant.getLine().getBeginPoint()));
            sb.append("</celldesigner:baseReactant>\n");
        }
        sb.append("</celldesigner:baseReactants>\n");
        return sb.toString();
    }

    private String getAnchorXml(Alias alias, Point2D point) {
        CellDesignerAliasConverter converter = new CellDesignerAliasConverter(alias);
        CellDesignerAnchor anchor = converter.getAnchorForCoordinates(alias, point);
        if (anchor != null) {
            return "<celldesigner:linkAnchor position=\"" + (Object)((Object)anchor) + "\"/>\n";
        }
        return "";
    }
}

