/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.geometry;

import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import lcsb.mapviewer.converter.model.celldesigner.geometry.AbstractCellDesignerAliasConverter;
import lcsb.mapviewer.converter.model.celldesigner.geometry.helper.CellDesignerAnchor;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAlias;

public class AntisenseRnaCellDesignerAliasConverter
extends AbstractCellDesignerAliasConverter<SpeciesAlias> {
    @Override
    public Point2D getPointCoordinates(SpeciesAlias alias, CellDesignerAnchor anchor) {
        if (this.invalidAnchorPosition(alias, anchor)) {
            return alias.getCenter();
        }
        ArrayList<Point2D> points = this.getPoints(alias);
        return this.getPolygonTransformation().getPointOnPolygonByAnchor(points, anchor);
    }

    @Override
    protected PathIterator getBoundPathIterator(SpeciesAlias alias) {
        return this.getAntisebseRnaPath(alias).getPathIterator(new AffineTransform());
    }

    private ArrayList<Point2D> getPoints(Alias alias) {
        double x = alias.getX();
        double y = alias.getY();
        double width = alias.getWidth();
        double height = alias.getHeight();
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        points.add(new Point2D.Double(x + width / 8.0, y + height / 2.0));
        points.add(new Point2D.Double(x, y));
        points.add(new Point2D.Double(x + width * 3.0 / 8.0, y));
        points.add(new Point2D.Double(x + width * 3.0 / 4.0, y));
        points.add(new Point2D.Double(x + width * 7.0 / 8.0, y + height / 2.0));
        points.add(new Point2D.Double(x + width, y + height));
        points.add(new Point2D.Double(x + width * 5.0 / 8.0, y + height));
        points.add(new Point2D.Double(x + width / 4.0, y + height));
        return points;
    }

    private GeneralPath getAntisebseRnaPath(Alias alias) {
        GeneralPath path = new GeneralPath(0, 4);
        path.moveTo(alias.getX(), alias.getY());
        path.lineTo(alias.getX() + alias.getWidth() * 3.0 / 4.0, alias.getY());
        path.lineTo(alias.getX() + alias.getWidth(), alias.getY() + alias.getHeight());
        path.lineTo(alias.getX() + alias.getWidth() / 4.0, alias.getY() + alias.getHeight());
        path.closePath();
        return path;
    }
}

