/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.geometry;

import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import lcsb.mapviewer.common.geometry.LineTransformation;
import lcsb.mapviewer.converter.model.celldesigner.geometry.ICellDesignerAliasConverter;
import lcsb.mapviewer.converter.model.celldesigner.geometry.helper.CellDesignerAnchor;
import lcsb.mapviewer.converter.model.celldesigner.geometry.helper.CellDesignerEllipseTransformation;
import lcsb.mapviewer.converter.model.celldesigner.geometry.helper.CellDesignerPolygonTransformation;
import lcsb.mapviewer.converter.model.celldesigner.geometry.helper.CellDesignerRectangleTransformation;
import lcsb.mapviewer.model.graphics.PolylineData;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import org.apache.log4j.Logger;

public abstract class AbstractCellDesignerAliasConverter<T extends Alias>
implements ICellDesignerAliasConverter<T> {
    private static Logger logger = Logger.getLogger(AbstractCellDesignerAliasConverter.class);
    private CellDesignerPolygonTransformation polygonTransformation = new CellDesignerPolygonTransformation();
    private LineTransformation lineTransformation = new LineTransformation();
    private CellDesignerEllipseTransformation ellipseTransformation = new CellDesignerEllipseTransformation();
    private CellDesignerRectangleTransformation rectangleTransformation = new CellDesignerRectangleTransformation();
    public static final int HOMODIMER_OFFSET = 6;

    protected AbstractCellDesignerAliasConverter() {
    }

    @Override
    public CellDesignerAnchor getAnchorForCoordinates(T alias, Point2D point) {
        double dist = Double.MAX_VALUE;
        CellDesignerAnchor result = null;
        for (CellDesignerAnchor anchor : CellDesignerAnchor.values()) {
            double newDist = this.getPointCoordinates(alias, anchor).distance(point);
            if (!(newDist < dist)) continue;
            dist = newDist;
            result = anchor;
        }
        if (dist > 1.0) {
            return null;
        }
        return result;
    }

    @Override
    public abstract Point2D getPointCoordinates(T var1, CellDesignerAnchor var2);

    @Override
    public Point2D getAnchorPointCoordinates(T alias, CellDesignerAnchor anchor, PolylineData ld) {
        if (anchor != null && anchor.getAngle() != null) {
            return this.getPointCoordinates(alias, anchor);
        }
        Point2D p1 = ld.getPoints().get(1);
        Point2D p2 = ld.getPoints().get(0);
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        double angle = Math.atan2(dy, dx);
        return this.getAnchorPointCoordinates(alias, angle);
    }

    protected Point2D getAnchorPointCoordinates(T alias, double angle) {
        Point2D result = null;
        if (((Alias)alias).getWidth() == 0.0 && ((Alias)alias).getHeight() == 0.0) {
            result = ((Alias)alias).getCenter();
        } else {
            double y;
            double x;
            Point2D.Double endPoint;
            double dist = Math.max(((Alias)alias).getWidth(), ((Alias)alias).getHeight()) * 2.0;
            Point2D startPoint = ((Alias)alias).getCenter();
            Line2D.Double line = new Line2D.Double(startPoint, endPoint = new Point2D.Double(x = startPoint.getX() - Math.cos(angle) * dist, y = startPoint.getY() - Math.sin(angle) * dist));
            result = this.lineTransformation.getIntersectionWithPathIterator(line, this.getBoundPathIterator(alias));
            if (result == null) {
                logger.warn("Unknown crossing point");
                logger.debug(((Line2D)line).getP1() + "; " + ((Line2D)line).getP2());
                result = ((Alias)alias).getCenter();
            }
        }
        return result;
    }

    protected abstract PathIterator getBoundPathIterator(T var1);

    protected boolean invalidAnchorPosition(T alias, CellDesignerAnchor anchor) {
        if (anchor == null || anchor.getAngle() == null) {
            return true;
        }
        return ((Alias)alias).getWidth() == 0.0 && ((Alias)alias).getHeight() == 0.0;
    }

    protected CellDesignerPolygonTransformation getPolygonTransformation() {
        return this.polygonTransformation;
    }

    protected void setPolygonTransformation(CellDesignerPolygonTransformation polygonTransformation) {
        this.polygonTransformation = polygonTransformation;
    }

    protected LineTransformation getLineTransformation() {
        return this.lineTransformation;
    }

    protected void setLineTransformation(LineTransformation lineTransformation) {
        this.lineTransformation = lineTransformation;
    }

    protected CellDesignerEllipseTransformation getEllipseTransformation() {
        return this.ellipseTransformation;
    }

    protected void setEllipseTransformation(CellDesignerEllipseTransformation ellipseTransformation) {
        this.ellipseTransformation = ellipseTransformation;
    }

    protected CellDesignerRectangleTransformation getRectangleTransformation() {
        return this.rectangleTransformation;
    }

    protected void setRectangleTransformation(CellDesignerRectangleTransformation rectangleTransformation) {
        this.rectangleTransformation = rectangleTransformation;
    }
}

