/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.compartment;

import java.util.List;
import java.util.Set;
import lcsb.mapviewer.common.Pair;
import lcsb.mapviewer.common.exception.InvalidXmlSchemaException;
import lcsb.mapviewer.converter.model.celldesigner.annotation.XmlAnnotationParser;
import lcsb.mapviewer.converter.model.celldesigner.species.AbstractElementXmlParser;
import lcsb.mapviewer.model.map.MiriamData;
import lcsb.mapviewer.model.map.agregator.Compartment;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompartmentXmlParser
extends AbstractElementXmlParser<Compartment> {
    private static Logger logger = Logger.getLogger(CompartmentXmlParser.class.getName());
    private XmlAnnotationParser xmlAnnotationParser = new XmlAnnotationParser();

    @Override
    public Pair<String, Compartment> parseXmlElement(Node compartmentNode, List<String> warnings) throws InvalidXmlSchemaException {
        Compartment compartment = new Compartment();
        compartment.setMetaId(this.getNodeAttr("metaid", compartmentNode));
        compartment.setCompartmentId(this.getNodeAttr("id", compartmentNode));
        compartment.setName(this.getNodeAttr("name", compartmentNode));
        NodeList nodes = compartmentNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("annotation")) {
                this.parseAnnotationNode(compartment, node, warnings);
                continue;
            }
            logger.debug("Unknown element of Compartment: " + node.getNodeName());
        }
        return new Pair<String, Compartment>(compartment.getCompartmentId(), compartment);
    }

    private void parseAnnotationNode(Compartment compartment, Node xmlNode, List<String> warnings) throws InvalidXmlSchemaException {
        NodeList annotationNodes = xmlNode.getChildNodes();
        for (int y = 0; y < annotationNodes.getLength(); ++y) {
            Node annotationNode = annotationNodes.item(y);
            if (annotationNode.getNodeType() != 1) continue;
            if (annotationNode.getNodeName().equalsIgnoreCase("rdf:RDF")) {
                compartment.addMiriamData(this.xmlAnnotationParser.parseRdfNode(annotationNode, warnings), warnings);
                continue;
            }
            if (annotationNode.getNodeName().equalsIgnoreCase("celldesigner:extension")) {
                this.parseExtensionNode(compartment, annotationNode);
                continue;
            }
            logger.debug("Unknown element of Compartment/annotation: " + annotationNode.getNodeName());
        }
    }

    private void parseExtensionNode(Compartment compartment, Node xmlNode) {
        NodeList annotationNodes = xmlNode.getChildNodes();
        for (int y = 0; y < annotationNodes.getLength(); ++y) {
            Node annotationNode = annotationNodes.item(y);
            if (annotationNode.getNodeType() != 1 || annotationNode.getNodeName().equalsIgnoreCase("celldesigner:name")) continue;
            logger.debug("Unknown element of Compartment/annotation/extension: " + annotationNode.getNodeName());
        }
    }

    @Override
    public String toXml(Compartment compartment) {
        StringBuilder sb = new StringBuilder("");
        sb.append("<compartment ");
        sb.append("metaid=\"" + compartment.getMetaId() + "\" ");
        sb.append("id=\"" + compartment.getCompartmentId() + "\" ");
        sb.append("name=\"" + compartment.getName() + "\" ");
        sb.append("size=\"1\" ");
        sb.append("units=\"volume\" ");
        String parentName = "default";
        if (compartment.getParent() != null) {
            parentName = compartment.getParent().getName();
        }
        if (!compartment.getCompartmentId().equals("default")) {
            sb.append("outside=\"" + parentName + "\" ");
        }
        sb.append(">\n");
        sb.append("<annotation>\n");
        sb.append("<celldesigner:extension>\n");
        sb.append("<celldesigner:name>" + compartment.getName() + "</celldesigner:name>\n");
        sb.append("</celldesigner:extension>\n");
        sb.append(this.xmlAnnotationParser.dataSetToXmlString((Set<MiriamData>)compartment.getMiriamData()));
        sb.append("</annotation>\n");
        sb.append("</compartment>\n");
        return sb.toString();
    }
}

