/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.annotation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lcsb.mapviewer.common.XmlParser;
import lcsb.mapviewer.common.comparator.DoubleComparator;
import lcsb.mapviewer.common.comparator.IntegerComparator;
import lcsb.mapviewer.common.comparator.StringComparator;
import lcsb.mapviewer.common.comparator.StringListComparator;
import lcsb.mapviewer.common.comparator.StringSetComparator;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidXmlSchemaException;
import lcsb.mapviewer.converter.model.celldesigner.annotation.NoteField;
import lcsb.mapviewer.converter.model.celldesigner.annotation.XmlAnnotationParser;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.MiriamData;
import lcsb.mapviewer.model.map.MiriamRelationType;
import lcsb.mapviewer.model.map.MiriamType;
import lcsb.mapviewer.model.map.reaction.Reaction;
import lcsb.mapviewer.model.map.species.Species;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class RestAnnotationParser
extends XmlParser {
    private static Logger logger = Logger.getLogger(RestAnnotationParser.class);
    private Pattern rdfNodePattern = Pattern.compile("(?<=<rdf:RDF)([\\s\\S]*?)(?=</rdf:RDF>)");
    private XmlAnnotationParser xmlAnnotationParser = new XmlAnnotationParser();

    public Set<MiriamData> getMiriamData(String annotationString) {
        HashSet<MiriamData> result = new HashSet<MiriamData>();
        if (annotationString == null) {
            return result;
        }
        String[] lines = annotationString.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            for (NoteField field : NoteField.values()) {
                ArrayList<String> ids;
                if (field.getMiriamType() == null || (ids = this.getIds(line, field.getCommonName() + ":")) == null) continue;
                Set<MiriamData> hgncData = this.idsToData(MiriamRelationType.BQ_BIOL_HAS_VERSION, field.getMiriamType(), ids);
                result.addAll(hgncData);
            }
        }
        return result;
    }

    public String createAnnotationString(Element element) {
        String name;
        StringBuilder sb = new StringBuilder();
        String symbol = element.getSymbol();
        if (symbol == null) {
            symbol = "";
        }
        if ((name = element.getFullName()) == null) {
            name = "";
        }
        sb.append(NoteField.SYMBOL.getCommonName() + ": " + symbol + "\n");
        sb.append(NoteField.NAME.getCommonName() + ": " + name + "\n");
        sb.append(NoteField.DESCRIPTION.getCommonName() + ": \n");
        sb.append(NoteField.PREVIOUS_SYMBOLS.getCommonName() + ": ");
        boolean first = true;
        for (String string : element.getFormerSymbols()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(string);
            first = false;
        }
        sb.append("\n");
        sb.append(NoteField.SYNONYMS.getCommonName() + ": ");
        first = true;
        for (String string : element.getSynonyms()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(string);
            first = false;
        }
        sb.append("\n");
        return sb.toString();
    }

    private String getParamByPrefix(String annotationString, String prefix) {
        if (annotationString == null) {
            return null;
        }
        String[] lines = annotationString.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!line.startsWith(prefix)) continue;
            String result = line.substring(prefix.length()).trim();
            if (result.equals("")) {
                return null;
            }
            return result;
        }
        return null;
    }

    public List<String> getSynonyms(String annotationString) {
        ArrayList<String> result = new ArrayList<String>();
        String synonyms = this.getParamByPrefix(annotationString, NoteField.SYNONYMS.getCommonName() + ":");
        if (synonyms != null) {
            for (String string : synonyms.split(",")) {
                if (string.trim().equals("")) continue;
                result.add(string.trim());
            }
        }
        return result;
    }

    public List<String> getFormerSymbols(String annotationString) {
        ArrayList<String> result = new ArrayList<String>();
        String formerSymbols = this.getParamByPrefix(annotationString, NoteField.PREVIOUS_SYMBOLS.getCommonName() + ":");
        if (formerSymbols != null) {
            for (String string : formerSymbols.split(",")) {
                if (string.trim().equals("")) continue;
                result.add(string.trim());
            }
        }
        return result;
    }

    protected ArrayList<String> getIds(String line, String baseId) {
        if (line.indexOf(baseId) >= 0) {
            String[] ids;
            ArrayList<String> result = new ArrayList<String>();
            String tmpLine = line.substring(baseId.length());
            for (String string : ids = tmpLine.split(",")) {
                if (string.trim().equals("")) continue;
                result.add(string.trim());
            }
            return result;
        }
        return null;
    }

    private Set<MiriamData> idsToData(MiriamRelationType type, MiriamType mType, ArrayList<String> ids) {
        HashSet<MiriamData> result = new HashSet<MiriamData>();
        for (String id : ids) {
            MiriamData md = new MiriamData(type, mType, id);
            result.add(md);
        }
        return result;
    }

    public void processNotes(Node node, Element element, List<String> warnings) {
        String notes = this.getNotes(node);
        this.processNotes(notes, element, warnings);
    }

    public String getNotes(Node node) {
        String notes = "";
        if (!node.getNodeName().contains("notes")) {
            throw new InvalidArgumentException("Invalid notes node");
        }
        Node htmlNode = this.getNode("html", node.getChildNodes());
        if (htmlNode == null) {
            notes = this.nodeToString(node).trim();
        } else {
            Node bodyNode = this.getNode("body", htmlNode.getChildNodes());
            notes = this.nodeToString(bodyNode).trim();
        }
        return notes.replaceAll("&amp;", "&");
    }

    private void setSynonymsToSpecies(Element element, String annotationString, List<String> warnings) {
        List<String> synonyms = this.getSynonyms(annotationString);
        if (synonyms.size() == 0) {
            return;
        }
        if (element.getSynonyms() == null || element.getSynonyms().size() == 0) {
            element.setSynonyms(synonyms);
        } else {
            StringSetComparator stringSetComparator = new StringSetComparator();
            HashSet<String> set1 = new HashSet<String>();
            HashSet<String> set2 = new HashSet<String>();
            set1.addAll(element.getSynonyms());
            set2.addAll(synonyms);
            if (stringSetComparator.compare((Set<String>)set1, (Set<String>)set2) != 0) {
                String warning = "[Element " + element.getElementId() + "] Synonyms list different than default [" + synonyms + "][" + element.getSynonyms() + "]. Ignoring.";
                if (warnings != null) {
                    warnings.add(warning);
                } else {
                    logger.warn(warning);
                }
            }
        }
    }

    private void setSynonymsToReaction(Reaction element, String annotationString, List<String> warnings) {
        List<String> synonyms = this.getSynonyms(annotationString);
        if (synonyms.size() == 0) {
            return;
        }
        if (element.getSynonyms() == null || element.getSynonyms().size() == 0) {
            element.setSynonyms(synonyms);
        } else {
            StringSetComparator stringSetComparator = new StringSetComparator();
            HashSet<String> set1 = new HashSet<String>();
            HashSet<String> set2 = new HashSet<String>();
            set1.addAll(element.getSynonyms());
            set2.addAll(synonyms);
            if (stringSetComparator.compare((Set<String>)set1, (Set<String>)set2) != 0) {
                String warning = "[Reaction " + element.getIdReaction() + "] Synonyms list different than default [" + synonyms + "][" + element.getSynonyms() + "]. Ignoring.";
                if (warnings != null) {
                    warnings.add(warning);
                } else {
                    logger.warn(warning);
                }
            }
        }
    }

    private void setFormerSymbolsToSpecies(Element element, String annotationString, List<String> warnings) {
        List<String> formerSymbols = this.getFormerSymbols(annotationString);
        if (formerSymbols.size() == 0) {
            return;
        }
        if (element.getFormerSymbols() == null || element.getFormerSymbols().size() == 0) {
            element.setFormerSymbols(formerSymbols);
        } else {
            StringListComparator stringListComparator = new StringListComparator();
            if (stringListComparator.compare(element.getFormerSymbols(), formerSymbols) != 0) {
                String warning = "[Element " + element.getElementId() + "] Former symbols list different than default [" + formerSymbols + "][" + element.getFormerSymbols() + "]. Ignoring.";
                if (warnings != null) {
                    warnings.add(warning);
                } else {
                    logger.warn(warning);
                }
            }
        }
    }

    private void setFullNameToSpecies(Element element, String annotationString, List<String> warnings) {
        StringComparator stringComparator = new StringComparator();
        String fullName = this.getParamByPrefix(annotationString, NoteField.NAME.getCommonName() + ":");
        if (fullName == null) {
            return;
        }
        if (element.getFullName() == null) {
            element.setFullName(fullName);
        } else if (stringComparator.compare(element.getFullName(), fullName, true) != 0) {
            String warning = "[Element " + element.getElementId() + "] New full name different than default [" + fullName + "][" + element.getFullName() + "]. Ignoring.";
            if (warnings != null) {
                warnings.add(warning);
            } else {
                logger.warn(warning);
            }
        }
    }

    private void setAbbreviation(Element element, String annotationString, List<String> warnings) {
        StringComparator stringComparator = new StringComparator();
        String abbreviation = this.getParamByPrefix(annotationString, NoteField.ABBREVIATION.getCommonName() + ":");
        if (abbreviation == null) {
            return;
        }
        if (element.getAbbreviation() == null) {
            element.setAbbreviation(abbreviation);
        } else if (stringComparator.compare(element.getAbbreviation(), abbreviation, true) != 0) {
            String warning = "[Element " + element.getElementId() + "] Abbreviation different than default [" + abbreviation + "][" + element.getAbbreviation() + "]. Ignoring.";
            if (warnings != null) {
                warnings.add(warning);
            } else {
                logger.warn(warning);
            }
        }
    }

    private void setAbbreviationToReaction(Reaction element, String annotationString, List<String> warnings) {
        StringComparator stringComparator = new StringComparator();
        String abbreviation = this.getParamByPrefix(annotationString, NoteField.ABBREVIATION.getCommonName() + ":");
        if (abbreviation == null) {
            return;
        }
        if (element.getAbbreviation() == null) {
            element.setAbbreviation(abbreviation);
        } else if (stringComparator.compare(element.getAbbreviation(), abbreviation, true) != 0) {
            String warning = "[Element " + element.getIdReaction() + "] Abbreviation different than default [" + abbreviation + "][" + element.getAbbreviation() + "]. Ignoring.";
            if (warnings != null) {
                warnings.add(warning);
            } else {
                logger.warn(warning);
            }
        }
    }

    private void setSubsystemToReaction(Reaction element, String annotationString, List<String> warnings) {
        StringComparator stringComparator = new StringComparator();
        String abbreviation = this.getParamByPrefix(annotationString, NoteField.SUBSYSTEM.getCommonName() + ":");
        if (abbreviation == null) {
            return;
        }
        if (element.getSubsystem() == null) {
            element.setSubsystem(abbreviation);
        } else if (stringComparator.compare(element.getSubsystem(), abbreviation, true) != 0) {
            String warning = "[Element " + element.getIdReaction() + "] Subsystem different than default [" + abbreviation + "][" + element.getSubsystem() + "]. Ignoring.";
            if (warnings != null) {
                warnings.add(warning);
            } else {
                logger.warn(warning);
            }
        }
    }

    private void setGeneProteinReactionToReaction(Reaction element, String annotationString, List<String> warnings) {
        StringComparator stringComparator = new StringComparator();
        String abbreviation = this.getParamByPrefix(annotationString, NoteField.GENE_PROTEIN_REACTION.getCommonName() + ":");
        if (abbreviation == null) {
            return;
        }
        if (element.getGeneProteinReaction() == null) {
            element.setGeneProteinReaction(abbreviation);
        } else if (stringComparator.compare(element.getGeneProteinReaction(), abbreviation, true) != 0) {
            String warning = "[Element " + element.getIdReaction() + "] GeneProteinReaction different than default [" + abbreviation + "][" + element.getGeneProteinReaction() + "]. Ignoring.";
            if (warnings != null) {
                warnings.add(warning);
            } else {
                logger.warn(warning);
            }
        }
    }

    private void setFormula(Element element, String annotationString, List<String> warnings) {
        StringComparator stringComparator = new StringComparator();
        String formula = this.getParamByPrefix(annotationString, NoteField.CHARGED_FORMULA.getCommonName() + ":");
        if (formula == null) {
            return;
        }
        if (element.getFormula() == null) {
            element.setFormula(formula);
        } else if (stringComparator.compare(element.getFormula(), formula, true) != 0) {
            String warning = "[Element " + element.getElementId() + "] Formula different than default [" + formula + "][" + element.getFormula() + "]. Ignoring.";
            if (warnings != null) {
                warnings.add(warning);
            } else {
                logger.warn(warning);
            }
        }
    }

    private void setFormulaToReaction(Reaction element, String annotationString, List<String> warnings) {
        StringComparator stringComparator = new StringComparator();
        String formula = this.getParamByPrefix(annotationString, NoteField.FORMULA.getCommonName() + ":");
        if (formula == null) {
            return;
        }
        if (element.getFormula() == null) {
            element.setFormula(formula);
        } else if (stringComparator.compare(element.getFormula(), formula, true) != 0) {
            String warning = "[Element " + element.getIdReaction() + "] Formula different than default [" + formula + "][" + element.getFormula() + "]. Ignoring.";
            if (warnings != null) {
                warnings.add(warning);
            } else {
                logger.warn(warning);
            }
        }
    }

    private void setMechanicalConfidenceScoreToReaction(Reaction element, String annotationString, List<String> warnings) {
        IntegerComparator integerComparator = new IntegerComparator();
        String formula = this.getParamByPrefix(annotationString, NoteField.MECHANICAL_CONFIDENCE_SCORE.getCommonName() + ":");
        if (formula == null) {
            return;
        }
        Integer charge = Integer.valueOf(formula);
        if (element.getMechanicalConfidenceScore() == null) {
            element.setMechanicalConfidenceScore(charge);
        } else if (integerComparator.compare(element.getMechanicalConfidenceScore(), charge) != 0) {
            String warning = "[Element " + element.getIdReaction() + "] MechanicalConfidenceScore different than default [" + formula + "][" + element.getFormula() + "]. Ignoring.";
            if (warnings != null) {
                warnings.add(warning);
            } else {
                logger.warn(warning);
            }
        }
    }

    private void setCharge(Species element, String annotationString, List<String> warnings) {
        IntegerComparator integerComparator = new IntegerComparator();
        String formula = this.getParamByPrefix(annotationString, NoteField.CHARGE.getCommonName() + ":");
        if (formula == null || formula.trim().equals("")) {
            return;
        }
        try {
            Integer charge = Integer.valueOf(formula);
            if (element.getCharge() == null) {
                element.setCharge(charge);
            } else if (integerComparator.compare(element.getCharge(), charge) != 0) {
                String warning = "[Element " + element.getElementId() + "] Charge different than default [" + formula + "][" + element.getCharge() + "]. Ignoring.";
                if (warnings != null) {
                    warnings.add(warning);
                } else {
                    logger.warn(warning);
                }
            }
        }
        catch (NumberFormatException e) {
            String warning = "[Element " + element.getElementId() + "] Invalid charge (integer value expected): " + formula;
            if (warnings != null) {
                warnings.add(warning);
            }
            logger.warn(warning);
        }
    }

    private void setLowerBoundToReaction(Reaction element, String annotationString, List<String> warnings) {
        DoubleComparator doubleComparator = new DoubleComparator();
        String formula = this.getParamByPrefix(annotationString, NoteField.LOWER_BOUND.getCommonName() + ":");
        if (formula == null || formula.trim().equals("")) {
            return;
        }
        Double value = Double.valueOf(formula);
        if (element.getLowerBound() == null) {
            element.setLowerBound(value);
        } else if (doubleComparator.compare(element.getLowerBound(), value) != 0) {
            String warning = "[Element " + element.getIdReaction() + "] LowerBound different than default [" + formula + "][" + element.getLowerBound() + "]. Ignoring.";
            if (warnings != null) {
                warnings.add(warning);
            } else {
                logger.warn(warning);
            }
        }
    }

    private void setUpperBoundToReaction(Reaction element, String annotationString, List<String> warnings) {
        DoubleComparator doubleComparator = new DoubleComparator();
        String formula = this.getParamByPrefix(annotationString, NoteField.UPPER_BOUND.getCommonName() + ":");
        if (formula == null || formula.trim().equals("")) {
            return;
        }
        Double value = Double.valueOf(formula);
        if (element.getUpperBound() == null) {
            element.setUpperBound(value);
        } else if (doubleComparator.compare(element.getUpperBound(), value) != 0) {
            String warning = "[Element " + element.getIdReaction() + "] UpperBound different than default [" + formula + "][" + element.getUpperBound() + "]. Ignoring.";
            if (warnings != null) {
                warnings.add(warning);
            } else {
                logger.warn(warning);
            }
        }
    }

    private void setSymbolToSpecies(Element element, String annotationString, List<String> warnings) {
        String symbol = this.getParamByPrefix(annotationString, NoteField.SYMBOL.getCommonName() + ":");
        if (symbol == null) {
            return;
        }
        if (element.getSymbol() == null) {
            element.setSymbol(symbol);
        } else if (!element.getSymbol().equals(symbol)) {
            String warning = "[Element " + element.getElementId() + "] New symbol different than default [" + symbol + "][" + element.getSymbol() + "]. Ignoring.";
            if (warnings != null) {
                warnings.add(warning);
            } else {
                logger.warn(warning);
            }
        }
    }

    private void setSymbolToReaction(Reaction element, String annotationString, List<String> warnings) {
        String symbol = this.getParamByPrefix(annotationString, NoteField.SYMBOL.getCommonName() + ":");
        if (symbol == null) {
            return;
        }
        if (element.getSymbol() == null) {
            element.setSymbol(symbol);
        } else if (!element.getSymbol().equals(symbol)) {
            String warning = "[Reaction " + element.getIdReaction() + "] New symbol different than default [" + symbol + "][" + element.getSymbol() + "]. Ignoring.";
            if (warnings != null) {
                warnings.add(warning);
            } else {
                logger.warn(warning);
            }
        }
    }

    private void setNotesToSpecies(Element element, String annotationString, List<String> warnings) {
        String description = this.getParamByPrefix(annotationString, NoteField.DESCRIPTION.getCommonName() + ":");
        if (description == null) {
            return;
        }
        if (element.getNotes().trim().equals("")) {
            element.setNotes(description);
        } else {
            if (element.getNotes().contains(description)) {
                return;
            }
            if (!element.getNotes().contains("Symbol")) {
                element.setNotes(element.getNotes().trim() + "\n" + description + "\n");
            } else {
                String description2 = this.getParamByPrefix(NoteField.DESCRIPTION.getCommonName() + ":", element.getNotes());
                if (!description.equals(description2)) {
                    String warning = "[Element " + element.getElementId() + "] Descriptions different. Cannot override: " + description + "\n" + description2;
                    if (warnings != null) {
                        warnings.add(warning.replaceAll("[\r\n]+", "_new_line_"));
                    } else {
                        logger.warn(warning);
                    }
                }
            }
        }
    }

    private void setNotesToReaction(Reaction element, String annotationString, List<String> warnings) {
        String description = this.getParamByPrefix(annotationString, NoteField.NAME.getCommonName() + ":");
        if (description == null) {
            return;
        }
        if (element.getNotes().trim().equals("")) {
            element.setNotes(description);
        } else {
            if (element.getNotes().contains(description)) {
                return;
            }
            if (!element.getNotes().contains("Symbol")) {
                element.setNotes(element.getNotes().trim() + "\n" + description + "\n");
            } else {
                String description2 = this.getParamByPrefix(NoteField.DESCRIPTION.getCommonName() + ":", element.getNotes());
                if (!description.equals(description2)) {
                    String warning = "[Reaction " + element.getIdReaction() + "] Descriptions different. Cannot override:\n" + description + "\n" + description2;
                    if (warnings != null) {
                        warnings.add(warning.replaceAll("[\r\n]+", "_new_line_"));
                    } else {
                        logger.warn(warning);
                    }
                }
            }
        }
    }

    public void processNotes(String notes, Reaction reaction, List<String> warnings) {
        StringBuilder annotations = new StringBuilder();
        String[] string = notes.split("\n");
        StringBuilder newNotes = new StringBuilder("");
        for (String string2 : string) {
            boolean remove = false;
            for (NoteField field : NoteField.values()) {
                if (!string2.startsWith(field.getCommonName() + ":")) continue;
                remove = true;
            }
            if (remove) {
                annotations.append(string2 + "\n");
                continue;
            }
            newNotes.append(string2 + "\n");
        }
        reaction.setNotes(newNotes.toString().trim());
        String ann = annotations.toString();
        this.setNotesToReaction(reaction, ann, warnings);
        this.setSymbolToReaction(reaction, ann, warnings);
        this.setSynonymsToReaction(reaction, ann, warnings);
        this.setAbbreviationToReaction(reaction, ann, warnings);
        this.setFormulaToReaction(reaction, ann, warnings);
        this.setMechanicalConfidenceScoreToReaction(reaction, ann, warnings);
        this.setLowerBoundToReaction(reaction, ann, warnings);
        this.setUpperBoundToReaction(reaction, ann, warnings);
        this.setSubsystemToReaction(reaction, ann, warnings);
        this.setGeneProteinReactionToReaction(reaction, ann, warnings);
    }

    public void processNotes(String notes, Element element, List<String> warnings) {
        StringBuilder annotations = new StringBuilder();
        String[] string = notes.split("\n");
        StringBuilder newNotes = new StringBuilder("");
        for (String string2 : string) {
            boolean remove = false;
            for (NoteField field : NoteField.values()) {
                if (!string2.startsWith(field.getCommonName() + ":")) continue;
                remove = true;
            }
            if (remove) {
                annotations.append(string2 + "\n");
                continue;
            }
            newNotes.append(string2 + "\n");
        }
        element.setNotes(newNotes.toString().trim());
        String ann = annotations.toString();
        this.setNotesToSpecies(element, ann, warnings);
        this.setSymbolToSpecies(element, ann, warnings);
        this.setFullNameToSpecies(element, ann, warnings);
        this.setSynonymsToSpecies(element, ann, warnings);
        this.setFormerSymbolsToSpecies(element, ann, warnings);
        this.setAbbreviation(element, ann, warnings);
        this.setFormula(element, ann, warnings);
        if (element instanceof Species) {
            this.setCharge((Species)element, ann, warnings);
        }
        try {
            this.processRdfDescription(element, warnings);
        }
        catch (InvalidXmlSchemaException e) {
            String warning = "[" + element.getElementId() + "] Problem with processing notes. Invalid RDF node.";
            if (warnings != null) {
                warnings.add(warning);
            }
            logger.warn(warning);
        }
    }

    void processRdfDescription(Element element, List<String> warnings) throws InvalidXmlSchemaException {
        String notes = element.getNotes();
        Matcher nodeMatcher = this.rdfNodePattern.matcher(notes);
        if (nodeMatcher.find()) {
            String rdfString = "<rdf:RDF" + nodeMatcher.group(1) + "</rdf:RDF>";
            element.addMiriamData(this.xmlAnnotationParser.parse(rdfString, warnings), warnings);
            notes = notes.substring(0, nodeMatcher.start() - "<rdf:RDF".length()) + notes.substring(nodeMatcher.end() + "</rdf:RDF>".length());
            element.setNotes(notes);
        }
    }
}

