/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.alias;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lcsb.mapviewer.common.XmlParser;
import lcsb.mapviewer.common.exception.InvalidXmlSchemaException;
import lcsb.mapviewer.converter.model.celldesigner.alias.CompartmentAliasXmlParser;
import lcsb.mapviewer.converter.model.celldesigner.alias.ComplexAliasXmlParser;
import lcsb.mapviewer.converter.model.celldesigner.alias.SpeciesAliasXmlParser;
import lcsb.mapviewer.model.map.layout.alias.ArtifitialCompartmentAlias;
import lcsb.mapviewer.model.map.layout.alias.CompartmentAlias;
import lcsb.mapviewer.model.map.layout.alias.ComplexAlias;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAlias;
import lcsb.mapviewer.model.map.model.Model;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AliasCollectionXmlParser
extends XmlParser {
    private Logger logger = Logger.getLogger(AliasCollectionXmlParser.class.getName());
    private SpeciesAliasXmlParser speciesAliasParser = null;
    private ComplexAliasXmlParser complexAliasParser = null;
    private CompartmentAliasXmlParser compartmentAliasParser = null;

    public AliasCollectionXmlParser(Model model) {
        this.speciesAliasParser = new SpeciesAliasXmlParser(model);
        this.complexAliasParser = new ComplexAliasXmlParser(model);
        this.compartmentAliasParser = new CompartmentAliasXmlParser(model);
    }

    public List<SpeciesAlias> parseXmlSpeciesAliasCollection(Node aliasListNode) throws InvalidXmlSchemaException {
        ArrayList<SpeciesAlias> result = new ArrayList<SpeciesAlias>();
        NodeList nodes = aliasListNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:speciesAlias")) {
                SpeciesAlias alias = this.speciesAliasParser.parseXmlAlias(node);
                result.add(alias);
                continue;
            }
            this.logger.warn("Unknown element of celldesigner:listOfSpeciesAliases: " + node.getNodeName());
        }
        return result;
    }

    public String speciesAliasCollectionToXmlString(Collection<SpeciesAlias> collection) {
        StringBuilder sb = new StringBuilder("<celldesigner:listOfSpeciesAliases>\n");
        for (SpeciesAlias alias : collection) {
            sb.append(this.speciesAliasParser.toXml(alias));
        }
        sb.append("</celldesigner:listOfSpeciesAliases>\n");
        return sb.toString();
    }

    public List<ComplexAlias> parseXmlComplexAliasCollection(Node aliasListNode) throws InvalidXmlSchemaException {
        ArrayList<ComplexAlias> result = new ArrayList<ComplexAlias>();
        NodeList nodes = aliasListNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:complexSpeciesAlias")) {
                ComplexAlias alias = this.complexAliasParser.parseXmlAlias(node);
                result.add(alias);
                continue;
            }
            this.logger.warn("Unknown element of celldesigner:listOfComplexSpeciesAliases: " + node.getNodeName());
        }
        for (ComplexAlias complexAlias : result) {
            this.complexAliasParser.addReference(complexAlias);
        }
        return result;
    }

    public String complexAliasCollectionToXmlString(Collection<ComplexAlias> collection) {
        StringBuilder sb = new StringBuilder("<celldesigner:listOfComplexSpeciesAliases>\n");
        for (ComplexAlias alias : collection) {
            sb.append(this.complexAliasParser.toXml(alias));
        }
        sb.append("</celldesigner:listOfComplexSpeciesAliases>\n");
        return sb.toString();
    }

    public List<CompartmentAlias> parseXmlCompartmentAliasCollection(Node aliasListNode) throws InvalidXmlSchemaException {
        ArrayList<CompartmentAlias> result = new ArrayList<CompartmentAlias>();
        NodeList nodes = aliasListNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:compartmentAlias")) {
                CompartmentAlias alias = this.compartmentAliasParser.parseXmlAlias(node);
                result.add(alias);
                continue;
            }
            this.logger.warn("Unknown element of celldesigner:listOfCompartmentAliases: " + node.getNodeName());
        }
        return result;
    }

    public String compartmentAliasCollectionToXmlString(Collection<CompartmentAlias> collection) {
        StringBuilder sb = new StringBuilder("<celldesigner:listOfCompartmentAliases>\n");
        for (CompartmentAlias alias : collection) {
            if (alias instanceof ArtifitialCompartmentAlias) continue;
            sb.append(this.compartmentAliasParser.toXml(alias));
        }
        sb.append("</celldesigner:listOfCompartmentAliases>\n");
        return sb.toString();
    }
}

