/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.cdplugin.copypaste;

import java.util.HashSet;
import java.util.Set;
import jp.sbi.celldesigner.MainWindow;
import lcsb.mapviewer.cdplugin.copypaste.CopyPastePlugin;
import lcsb.mapviewer.common.Pair;
import lcsb.mapviewer.common.XmlParser;
import lcsb.mapviewer.common.exception.InvalidXmlSchemaException;
import lcsb.mapviewer.converter.model.celldesigner.annotation.XmlAnnotationParser;
import lcsb.mapviewer.model.map.MiriamData;
import lcsb.mapviewer.model.map.MiriamRelationType;
import lcsb.mapviewer.model.map.MiriamType;
import org.apache.log4j.Logger;

public class CopyPasteAbstractAction
extends XmlParser {
    private final Logger logger = Logger.getLogger(CopyPasteAbstractAction.class);
    private static final String PREFIX = "[MIRIAM]";
    private CopyPastePlugin plug;
    private MainWindow window;

    protected String serialize(MiriamData md) {
        return "[MIRIAM]\t" + md.getRelationType().getStringRepresentation() + "\t" + md.getDataType().getUris().get(0) + "\t" + md.getResource();
    }

    protected MiriamData deserialize(String string) {
        if (string == null) {
            return null;
        }
        String[] tmp = string.split("\t");
        if (tmp.length == 4 && PREFIX.equals(tmp[0])) {
            String relation = tmp[1];
            String uri = tmp[2];
            String resource = tmp[3];
            MiriamType mt = MiriamType.getTypeByUri(uri);
            MiriamRelationType mrt = MiriamRelationType.getTypeByStringRepresentation(relation);
            if (mt == null || mrt == null) {
                return null;
            }
            return new MiriamData(mrt, mt, resource);
        }
        return null;
    }

    protected String getCopyString(String annotationString, String notesString) throws InvalidXmlSchemaException {
        XmlAnnotationParser xap = new XmlAnnotationParser();
        Set<MiriamData> set = xap.parse(annotationString, null);
        StringBuilder result = new StringBuilder();
        for (MiriamData md : set) {
            result.append(this.serialize(md) + "\n");
        }
        result.append(notesString);
        return result.toString();
    }

    protected Pair<Set<MiriamData>, String> getAnnotationDataFromClipboardString(String value) {
        if (value == null) {
            return new Pair<Object, Object>(null, null);
        }
        String[] rows = value.split("\n");
        StringBuilder sb = new StringBuilder("");
        boolean miriam = true;
        HashSet<MiriamData> set = new HashSet<MiriamData>();
        for (int i = 0; i < rows.length; ++i) {
            String row = rows[i];
            if (miriam) {
                MiriamData md = this.deserialize(row);
                if (md != null) {
                    set.add(md);
                } else {
                    miriam = false;
                }
            }
            if (miriam) continue;
            sb.append(row);
            sb.append("\n");
        }
        String notes = sb.toString().trim();
        return new Pair<Set<MiriamData>, String>(set, notes);
    }

    protected CopyPastePlugin getPlug() {
        return this.plug;
    }

    protected void setPlug(CopyPastePlugin plug) {
        this.plug = plug;
    }

    protected MainWindow getWindow() {
        return this.window;
    }

    protected void setWindow(MainWindow window) {
        this.window = window;
    }
}

