/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.cdplugin.copypaste;

import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginReaction;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpecies;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;
import lcsb.mapviewer.cdplugin.copypaste.CopyPasteAbstractAction;
import lcsb.mapviewer.cdplugin.copypaste.CopyPastePlugin;
import lcsb.mapviewer.common.SystemClipboard;
import lcsb.mapviewer.common.exception.InvalidXmlSchemaException;
import org.apache.log4j.Logger;

public class CopyAction
extends CopyPasteAbstractAction {
    private final Logger logger = Logger.getLogger(CopyAction.class.getName());

    public void performAnnotation(CopyPastePlugin plug, PluginListOf speciesList, MainWindow win) {
        if (speciesList.size() == 0) {
            return;
        }
        SystemClipboard sc = new SystemClipboard();
        this.setWindow(win);
        this.setPlug(plug);
        int size = speciesList.size();
        PluginSpecies chosenElement = null;
        String id = "";
        for (int i = 0; i < size; ++i) {
            PluginSBase element = speciesList.get(i);
            if (element instanceof PluginSpeciesAlias) {
                PluginSpeciesAlias alias = (PluginSpeciesAlias)element;
                PluginSpecies species = alias.getSpecies();
                if (chosenElement == null) {
                    chosenElement = species;
                    id = species.getId();
                    continue;
                }
                if (id.compareTo(species.getId()) >= 0) continue;
                chosenElement = species;
                id = species.getId();
                continue;
            }
            if (element instanceof PluginReaction) {
                PluginReaction reaction = (PluginReaction)element;
                if (chosenElement == null) {
                    chosenElement = reaction;
                    id = reaction.getId();
                    continue;
                }
                if (id.compareTo(reaction.getId()) >= 0) continue;
                chosenElement = reaction;
                id = reaction.getId();
                continue;
            }
            this.logger.warn("Unknown class type :" + element.getClass());
        }
        if (chosenElement != null) {
            try {
                sc.setClipboardContents(this.getCopyString(chosenElement.getAnnotationString(), chosenElement.getNotesString()));
            }
            catch (InvalidXmlSchemaException e) {
                this.logger.warn("Problem with creating copy-paste String", e);
            }
        }
    }
}

