/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations;

import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class JandexHelper {
    private static final Map<String, Object> DEFAULT_VALUES_BY_ELEMENT = new HashMap<String, Object>();

    private JandexHelper() {
    }

    public static <T> T getValue(AnnotationInstance annotation, String element, Class<T> type) throws AssertionFailure {
        if (Class.class.equals(type)) {
            throw new AssertionFailure("Annotation parameters of type Class should be retrieved as strings (fully qualified class names)");
        }
        AnnotationValue annotationValue = annotation.value(element);
        try {
            if (annotationValue != null) {
                return JandexHelper.explicitAnnotationParameter(annotationValue, type);
            }
            return JandexHelper.defaultAnnotationParameter(JandexHelper.getDefaultValue(annotation, element), type);
        }
        catch (ClassCastException e) {
            throw new AssertionFailure(String.format("the annotation property %s of annotation %s is not of type %s", element, annotation.name(), type.getName()));
        }
    }

    public static <T extends Enum<T>> T getEnumValue(AnnotationInstance annotation, String element, Class<T> type) {
        AnnotationValue val = annotation.value(element);
        if (val == null) {
            return (T)((Enum)JandexHelper.getDefaultValue(annotation, element));
        }
        return Enum.valueOf(type, val.asEnum());
    }

    public static String getPropertyName(AnnotationTarget target) {
        String propertyName;
        if (!(target instanceof MethodInfo) && !(target instanceof FieldInfo)) {
            throw new AssertionFailure("Unexpected annotation target " + target.toString());
        }
        if (target instanceof FieldInfo) {
            return ((FieldInfo)target).name();
        }
        String methodName = ((MethodInfo)target).name();
        if (methodName.startsWith("is")) {
            propertyName = Introspector.decapitalize(methodName.substring(2));
        } else if (methodName.startsWith("has")) {
            propertyName = Introspector.decapitalize(methodName.substring(3));
        } else if (methodName.startsWith("get")) {
            propertyName = Introspector.decapitalize(methodName.substring(3));
        } else {
            throw new AssertionFailure("Expected a method following the Java Bean notation");
        }
        return propertyName;
    }

    public static AnnotationInstance getSingleAnnotation(ClassInfo classInfo, DotName annotationName) throws AssertionFailure {
        return JandexHelper.getSingleAnnotation(classInfo.annotations(), annotationName);
    }

    public static AnnotationInstance getSingleAnnotation(Map<DotName, List<AnnotationInstance>> annotations, DotName annotationName) throws AssertionFailure {
        List<AnnotationInstance> annotationList = annotations.get(annotationName);
        if (annotationList == null) {
            return null;
        }
        if (annotationList.size() == 1) {
            return annotationList.get(0);
        }
        throw new AssertionFailure("Found more than one instance of the annotation " + annotationList.get(0).name().toString() + ". Expected was one.");
    }

    public static boolean containsSingleAnnotations(Map<DotName, List<AnnotationInstance>> annotations, DotName annotationName) throws AssertionFailure {
        return JandexHelper.getSingleAnnotation(annotations, annotationName) != null;
    }

    public static Index indexForClass(ClassLoaderService classLoaderService, Class<?> ... classes) {
        Indexer indexer = new Indexer();
        for (Class<?> clazz : classes) {
            InputStream stream = classLoaderService.locateResourceStream(clazz.getName().replace('.', '/') + ".class");
            try {
                indexer.index(stream);
            }
            catch (IOException e) {
                StringBuilder builder = new StringBuilder();
                builder.append("[");
                int count = 0;
                for (Class<?> c : classes) {
                    builder.append(c.getName());
                    if (count < classes.length - 1) {
                        builder.append(",");
                    }
                    ++count;
                }
                builder.append("]");
                throw new HibernateException("Unable to create annotation index for " + builder.toString());
            }
        }
        return indexer.complete();
    }

    public static Map<DotName, List<AnnotationInstance>> getMemberAnnotations(ClassInfo classInfo, String name) {
        if (classInfo == null) {
            throw new IllegalArgumentException("classInfo cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        HashMap<DotName, List<AnnotationInstance>> annotations = new HashMap<DotName, List<AnnotationInstance>>();
        for (List annotationList : classInfo.annotations().values()) {
            for (AnnotationInstance instance : annotationList) {
                String targetName = null;
                if (instance.target() instanceof FieldInfo) {
                    targetName = ((FieldInfo)instance.target()).name();
                } else if (instance.target() instanceof MethodInfo) {
                    targetName = ((MethodInfo)instance.target()).name();
                }
                if (targetName == null || !name.equals(targetName)) continue;
                JandexHelper.addAnnotationToMap(instance, annotations);
            }
        }
        return annotations;
    }

    private static void addAnnotationToMap(AnnotationInstance instance, Map<DotName, List<AnnotationInstance>> annotations) {
        List<Object> list;
        DotName dotName = instance.name();
        if (annotations.containsKey(dotName)) {
            list = annotations.get(dotName);
        } else {
            list = new ArrayList();
            annotations.put(dotName, list);
        }
        list.add(instance);
    }

    private static Object getDefaultValue(AnnotationInstance annotation, String element) {
        String name = annotation.name().toString();
        String fqElement = name + '.' + element;
        Object val = DEFAULT_VALUES_BY_ELEMENT.get(fqElement);
        if (val != null) {
            return val;
        }
        try {
            val = Index.class.getClassLoader().loadClass(name).getMethod(element, new Class[0]).getDefaultValue();
            DEFAULT_VALUES_BY_ELEMENT.put(fqElement, val);
            return val == null ? null : val;
        }
        catch (RuntimeException error) {
            throw error;
        }
        catch (Exception error) {
            throw new AssertionFailure(String.format("The annotation %s does not define a parameter '%s'", name, element), error);
        }
    }

    private static <T> T defaultAnnotationParameter(Object defaultValue, Class<T> type) {
        AnnotationInstance[] returnValue = defaultValue;
        if (defaultValue.getClass().isArray() && defaultValue.getClass().getComponentType().isAnnotation()) {
            returnValue = new AnnotationInstance[]{};
        }
        return type.cast(returnValue);
    }

    private static <T> T explicitAnnotationParameter(AnnotationValue annotationValue, Class<T> type) {
        Object[] returnValue = annotationValue.value();
        if (returnValue instanceof Type) {
            returnValue = ((Type)returnValue).name().toString();
        }
        if (type.isArray()) {
            AnnotationValue[] values = (AnnotationValue[])returnValue;
            Class<?> componentType = type.getComponentType();
            Object[] arr = (Object[])Array.newInstance(componentType, values.length);
            for (int i = 0; i < values.length; ++i) {
                arr[i] = componentType.cast(values[i].value());
            }
            returnValue = arr;
        }
        return type.cast(returnValue);
    }
}

