/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.user;

import lcsb.mapviewer.model.Project;
import lcsb.mapviewer.model.map.layout.Layout;
import lcsb.mapviewer.model.user.BasicPrivilege;
import lcsb.mapviewer.model.user.ObjectPrivilege;

public enum PrivilegeType {
    VIEW_PROJECT(ObjectPrivilege.class, Project.class, "View project"),
    ADD_MAP(BasicPrivilege.class, null, "Add project"),
    EDIT_MISSING_CONNECTIONS_PROJECT(ObjectPrivilege.class, Project.class, "Edit suggested connections"),
    EDIT_COMMENTS_PROJECT(ObjectPrivilege.class, Project.class, "Manage comments"),
    DRUG_TARGETING_ADVANCED_VIEW_PROJECT(ObjectPrivilege.class, Project.class, "Drug targeting advanced view"),
    PROJECT_MANAGEMENT(BasicPrivilege.class, null, "Map management"),
    USER_MANAGEMENT(BasicPrivilege.class, null, "User management"),
    CUSTOM_LAYOUTS(BasicPrivilege.class, null, "Custom layouts", true),
    LAYOUT_VIEW(ObjectPrivilege.class, Layout.class, "View layout"),
    CONFIGURATION_MANAGE(BasicPrivilege.class, null, "Manage configuration");

    private Class<? extends BasicPrivilege> privilegeClassType;
    private Class<?> privilegeObjectType;
    private String commonName;
    private boolean numeric = false;

    private PrivilegeType(Class<? extends BasicPrivilege> privilegeClazz, Class<?> objectClazz, String commonName) {
        this.privilegeClassType = privilegeClazz;
        this.privilegeObjectType = objectClazz;
        this.commonName = commonName;
    }

    private PrivilegeType(Class<? extends BasicPrivilege> privilegeClazz, Class<?> objectClazz, String commonName, boolean numeric) {
        this.privilegeClassType = privilegeClazz;
        this.privilegeObjectType = objectClazz;
        this.commonName = commonName;
        this.numeric = true;
    }

    public Class<? extends BasicPrivilege> getPrivilegeClassType() {
        return this.privilegeClassType;
    }

    public Class<?> getPrivilegeObjectType() {
        return this.privilegeObjectType;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public boolean isNumeric() {
        return this.numeric;
    }
}

