/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.user;

import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lcsb.mapviewer.model.user.PrivilegeType;
import lcsb.mapviewer.model.user.User;

@Entity
@Table(name="privilege_table")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="privilege_class_type_db", discriminatorType=DiscriminatorType.STRING)
@DiscriminatorValue(value="BASIC_PRIVILEGE")
public class BasicPrivilege {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="idDb", unique=true, nullable=false)
    private int id;
    @ManyToOne(fetch=FetchType.LAZY)
    private User user;
    private PrivilegeType type;
    private int level;

    public BasicPrivilege(int level, PrivilegeType type, User user) {
        this.level = level;
        this.type = type;
        this.user = user;
    }

    public BasicPrivilege() {
    }

    public boolean equalsPrivilege(BasicPrivilege privilege) {
        if (privilege == null) {
            return false;
        }
        return this.type.equals((Object)privilege.getType());
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public PrivilegeType getType() {
        return this.type;
    }

    public void setType(PrivilegeType type) {
        this.type = type;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }
}

