/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.species.fields;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.model.map.species.Species;
import lcsb.mapviewer.model.map.species.fields.ModificationState;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="rna_region_table")
@GenericGenerator(name="test-increment-strategy", strategy="increment")
public class RnaRegion {
    private static final double DEFAULT_SIZE = 0.1;
    private static Logger logger = Logger.getLogger(RnaRegion.class.getName());
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="iddb", unique=true, nullable=false)
    private int id;
    @Column(name="idrnaregion")
    private String idRnaRegion = "";
    @Column(name="type")
    private String type = "";
    @Column(name="state")
    private ModificationState state = null;
    @Column(name="name")
    private String name = "";
    @Column(name="size")
    private double size = 0.1;
    @Column(name="pos")
    private Double pos;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idSpeciesDb")
    private Species species;

    public RnaRegion() {
    }

    public RnaRegion(RnaRegion mr) {
        this.id = mr.id;
        this.size = mr.size;
        this.setPos(mr.getPos());
        this.type = mr.type;
        this.state = mr.state;
        this.name = mr.name;
    }

    public void setSize(String text) {
        try {
            this.size = Double.parseDouble(text);
        }
        catch (Exception e) {
            logger.error("Invalid angle: " + text);
        }
    }

    public void setPos(String text) {
        try {
            this.setPos(Double.parseDouble(text));
        }
        catch (Exception e) {
            logger.debug("Invalid pos: " + text);
            this.setPos(0.0);
        }
    }

    public void update(RnaRegion mr) {
        if (this.idRnaRegion != null && !this.idRnaRegion.equals("") && !this.idRnaRegion.equals(mr.getIdRnaRegion())) {
            throw new InvalidArgumentException("Cannot update from mr with different id");
        }
        this.size = mr.getSize();
        if (mr.getState() != null) {
            this.state = mr.getState();
        }
        if (mr.getName() != null) {
            this.name = mr.getName();
        }
        if (mr.getPos() != null) {
            this.setPos(mr.getPos());
        }
    }

    public String toString() {
        String result = "" + this.getIdRnaRegion() + "," + this.getType() + "," + this.getPos() + "," + this.getSize() + "," + (Object)((Object)this.getState()) + ",";
        return result;
    }

    public int getId() {
        return this.id;
    }

    public void setId2(int id) {
        this.id = id;
    }

    public String getIdRnaRegion() {
        return this.idRnaRegion;
    }

    public void setIdRnaRegion(String id) {
        this.idRnaRegion = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ModificationState getState() {
        return this.state;
    }

    public void setState(ModificationState state) {
        this.state = state;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        this.size = size;
    }

    public Double getPos() {
        return this.pos;
    }

    public void setPos(Double pos) {
        this.pos = pos;
    }

    public Species getSpecies() {
        return this.species;
    }

    public void setSpecies(Species species) {
        this.species = species;
    }
}

