/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.species.fields;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.model.map.species.Species;
import lcsb.mapviewer.model.map.species.fields.ModificationState;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="antisense_rna_region_table")
@GenericGenerator(name="test-increment-strategy", strategy="increment")
public class AntisenseRnaRegion {
    private static final double DEFAULT_SIZE = 0.1;
    private static Logger logger = Logger.getLogger(AntisenseRnaRegion.class.getName());
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="iddb", unique=true, nullable=false)
    private int id;
    @Column(name="idantisensernaregion")
    private String idAntisenseRnaRegion = "";
    @Column(name="name")
    private String name = "";
    @Column(name="state")
    private ModificationState state = null;
    @Column(name="type")
    private AntisenseRnaRegionType type;
    @Column(name="size")
    private double size = 0.1;
    @Column(name="pos")
    private Double pos;
    @Cascade(value={CascadeType.ALL})
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idSpeciesDb")
    private Species species;

    public AntisenseRnaRegion() {
    }

    public AntisenseRnaRegion(AntisenseRnaRegion original) {
        this.idAntisenseRnaRegion = original.idAntisenseRnaRegion;
        this.name = original.name;
        this.size = original.size;
        this.pos = original.pos;
        this.type = original.type;
    }

    public AntisenseRnaRegion copy() {
        AntisenseRnaRegion result = new AntisenseRnaRegion(this);
        return result;
    }

    public void setSize(String text) {
        try {
            this.size = Double.parseDouble(text);
        }
        catch (Exception e) {
            logger.error("Invalid angle: " + text);
        }
    }

    public void setPos(String text) {
        try {
            this.pos = Double.parseDouble(text);
        }
        catch (Exception e) {
            logger.debug("Invalid pos: " + text);
            this.pos = 0.0;
        }
    }

    public void update(AntisenseRnaRegion mr) {
        if (this.idAntisenseRnaRegion != null && !this.idAntisenseRnaRegion.equals("") && !this.idAntisenseRnaRegion.equals(mr.getIdAntisenseRnaRegion())) {
            throw new InvalidArgumentException("Cannot update from mr with different id");
        }
        this.size = mr.getSize();
        if (mr.getState() != null) {
            this.state = mr.getState();
        }
        if (mr.getName() != null) {
            this.name = mr.getName();
        }
        if (mr.getPos() != null) {
            this.setPos(mr.getPos());
        }
    }

    public String toString() {
        String result = this.getIdAntisenseRnaRegion() + "," + this.getName() + "," + (Object)((Object)this.getType()) + "," + this.getPos() + "," + this.getSize() + ",";
        return result;
    }

    public String getIdAntisenseRnaRegion() {
        return this.idAntisenseRnaRegion;
    }

    public void setIdAntisenseRnaRegion(String idAntisenseRnaRegion) {
        this.idAntisenseRnaRegion = idAntisenseRnaRegion;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ModificationState getState() {
        return this.state;
    }

    public void setState(ModificationState state) {
        this.state = state;
    }

    public AntisenseRnaRegionType getType() {
        return this.type;
    }

    public void setType(AntisenseRnaRegionType type) {
        this.type = type;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        this.size = size;
    }

    public Double getPos() {
        return this.pos;
    }

    public void setPos(Double pos) {
        this.pos = pos;
    }

    public Species getSpecies() {
        return this.species;
    }

    public void setSpecies(Species species) {
        this.species = species;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public static enum AntisenseRnaRegionType {
        MODIFICATION_SITE("Modification Site"),
        CODING_REGION("CodingRegion"),
        PROTEIN_BINDING_DOMAIN("proteinBindingDomain");

        private String name;

        private AntisenseRnaRegionType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static AntisenseRnaRegionType getTypeByString(String name) {
            for (AntisenseRnaRegionType type : AntisenseRnaRegionType.values()) {
                if (!type.getName().equalsIgnoreCase(name)) continue;
                return type;
            }
            return null;
        }
    }
}

