/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.species;

import java.util.Comparator;
import lcsb.mapviewer.common.comparator.StringComparator;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.map.species.SimpleMolecule;
import lcsb.mapviewer.model.map.species.SpeciesComparator;
import org.apache.log4j.Logger;

public class SimpleMoleculeComparator
implements Comparator<SimpleMolecule> {
    private Logger logger = Logger.getLogger(SimpleMoleculeComparator.class);
    private double epsilon;

    public SimpleMoleculeComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public SimpleMoleculeComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(SimpleMolecule arg0, SimpleMolecule arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof SimpleMolecule) {
                return this.internalCompare(arg0, arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        return -1;
    }

    private int internalCompare(SimpleMolecule arg0, SimpleMolecule arg1) {
        SpeciesComparator speciesComparator = new SpeciesComparator(this.epsilon);
        int result = speciesComparator.internalCompare(arg0, arg1);
        if (result != 0) {
            return result;
        }
        if (Integer.valueOf(arg0.getHomodimer()).compareTo(arg1.getHomodimer()) != 0) {
            this.logger.debug("Homodimer different: " + arg0.getHomodimer() + ", " + arg1.getHomodimer());
            return Integer.valueOf(arg0.getHomodimer()).compareTo(arg1.getHomodimer());
        }
        StringComparator stringComparator = new StringComparator();
        if (stringComparator.compare(arg0.getSmiles(), arg1.getSmiles()) != 0) {
            this.logger.debug("Smiles different: " + arg0.getSmiles() + ", " + arg1.getSmiles());
            return stringComparator.compare(arg0.getSmiles(), arg1.getSmiles());
        }
        if (stringComparator.compare(arg0.getInChIKey(), arg1.getInChIKey()) != 0) {
            this.logger.debug("InChIKey different: " + arg0.getInChIKey() + ", " + arg1.getInChIKey());
            return stringComparator.compare(arg0.getInChIKey(), arg1.getInChIKey());
        }
        if (stringComparator.compare(arg0.getInChI(), arg1.getInChI()) != 0) {
            this.logger.debug("InChI different: " + arg0.getInChI() + ", " + arg1.getInChI());
            return stringComparator.compare(arg0.getInChI(), arg1.getInChI());
        }
        return 0;
    }
}

