/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.species;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import lcsb.mapviewer.common.comparator.StringSetComparator;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.map.species.Rna;
import lcsb.mapviewer.model.map.species.SpeciesComparator;
import lcsb.mapviewer.model.map.species.fields.RnaRegion;

public class RnaComparator
implements Comparator<Rna> {
    private double epsilon;

    public RnaComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public RnaComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(Rna arg0, Rna arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof Rna) {
                return this.internalCompare(arg0, arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        return -1;
    }

    private int internalCompare(Rna arg0, Rna arg1) {
        SpeciesComparator speciesComparator = new SpeciesComparator(this.epsilon);
        int result = speciesComparator.internalCompare(arg0, arg1);
        if (result != 0) {
            return result;
        }
        StringSetComparator stringSetComparator = new StringSetComparator();
        HashSet<String> set1 = new HashSet<String>();
        HashSet<String> set2 = new HashSet<String>();
        for (RnaRegion region : arg0.getRegions()) {
            set1.add(region.toString());
        }
        for (RnaRegion region : arg1.getRegions()) {
            set2.add(region.toString());
        }
        if (stringSetComparator.compare((Set<String>)set1, (Set<String>)set2) != 0) {
            return stringSetComparator.compare((Set<String>)set1, (Set<String>)set2);
        }
        return 0;
    }
}

