/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.species;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import lcsb.mapviewer.model.map.species.Species;
import lcsb.mapviewer.model.map.species.fields.RnaRegion;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

@Entity
@DiscriminatorValue(value="RNA")
public class Rna
extends Species {
    private static Logger logger = Logger.getLogger(Rna.class.getName());
    @Cascade(value={CascadeType.ALL})
    @OneToMany(mappedBy="species", orphanRemoval=true)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private List<RnaRegion> regions = new ArrayList<RnaRegion>();

    public Rna(Species species) {
        super(species);
        if (species instanceof Rna) {
            Rna rna = (Rna)species;
            for (RnaRegion region : rna.getRegions()) {
                this.addRegion(new RnaRegion(region));
            }
        }
    }

    public Rna() {
    }

    @Override
    public Rna copy() {
        return new Rna(this);
    }

    @Override
    public List<String> update(Species species) {
        List<String> warnings = super.update(species);
        if (species instanceof Rna) {
            Rna rna = (Rna)species;
            for (RnaRegion mr : this.getRegions()) {
                mr.setState(null);
            }
            for (RnaRegion region : rna.getRegions()) {
                this.updateRegion(region);
            }
        }
        return warnings;
    }

    private void updateRegion(RnaRegion param) {
        for (RnaRegion region : this.regions) {
            if (!region.getIdRnaRegion().equals(param.getIdRnaRegion())) continue;
            region.update(param);
            return;
        }
        this.addRegion(new RnaRegion(param));
    }

    @Override
    public String getStringType() {
        return "RNA";
    }

    public void addRegion(RnaRegion rnaRegion) {
        for (RnaRegion region2 : this.regions) {
            if (!region2.getIdRnaRegion().equals(rnaRegion.getIdRnaRegion())) continue;
            region2.update(rnaRegion);
            return;
        }
        this.regions.add(rnaRegion);
        rnaRegion.setSpecies(this);
    }

    public List<RnaRegion> getRegions() {
        return this.regions;
    }

    public void setRegions(List<RnaRegion> regions) {
        this.regions = regions;
    }
}

