/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.species;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import lcsb.mapviewer.common.exception.NotImplementedException;
import lcsb.mapviewer.model.map.species.Species;
import lcsb.mapviewer.model.map.species.fields.ModificationResidue;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

@Entity
@DiscriminatorValue(value="Protein")
public class Protein
extends Species {
    private static Logger logger = Logger.getLogger(Protein.class.getName());
    @Column(name="homodimer")
    private int homodimer = 1;
    @Column(name="structuralState")
    private String structuralState = null;
    @Cascade(value={CascadeType.ALL})
    @OneToMany(mappedBy="species", orphanRemoval=true)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private List<ModificationResidue> modificationResidues = new ArrayList<ModificationResidue>();

    public Protein(Species species) {
        super(species);
        if (species instanceof Protein) {
            Protein protein = (Protein)species;
            this.homodimer = protein.homodimer;
            if (protein.getStructuralState() != null) {
                this.setStructuralState(new String(protein.getStructuralState()));
            }
            for (ModificationResidue mr : protein.getModificationResidues()) {
                this.addModificationResidue(new ModificationResidue(mr));
            }
        }
    }

    @Override
    public List<String> update(Species species) {
        List<String> warnings = super.update(species);
        if (species instanceof Protein) {
            Protein protein = (Protein)species;
            this.setHomodimer(protein.getHomodimer());
            if (this.getStructuralState() == null || this.getStructuralState().equals("")) {
                this.setStructuralState(protein.getStructuralState());
            }
            for (ModificationResidue mr : protein.getModificationResidues()) {
                this.addModificationResidue(mr);
            }
        }
        return warnings;
    }

    public Protein() {
    }

    @Override
    public Protein copy() {
        if (this.getClass().equals(Protein.class)) {
            return new Protein(this);
        }
        throw new NotImplementedException("Copy method for " + this.getClass() + " class not implemented");
    }

    @Override
    public String getStringType() {
        return "Protein";
    }

    public void addModificationResidue(ModificationResidue modificationResidue) {
        for (ModificationResidue mr : this.modificationResidues) {
            if (!mr.getIdModificationResidue().equals(modificationResidue.getIdModificationResidue())) continue;
            mr.update(modificationResidue);
            return;
        }
        this.modificationResidues.add(modificationResidue);
        modificationResidue.setSpecies(this);
    }

    public String getStructuralState() {
        return this.structuralState;
    }

    public void setStructuralState(String structuralState) {
        if (this.structuralState != null && !this.structuralState.equals("") && !this.structuralState.equals(structuralState)) {
            logger.warn("replacing structural state, Old: " + this.structuralState + " into new: " + structuralState);
        }
        this.structuralState = structuralState;
    }

    public List<ModificationResidue> getModificationResidues() {
        return this.modificationResidues;
    }

    public void setModificationResidues(List<ModificationResidue> modificationResidues) {
        this.modificationResidues = modificationResidues;
    }

    public int getHomodimer() {
        return this.homodimer;
    }

    public void setHomodimer(int homodimer) {
        this.homodimer = homodimer;
    }
}

