/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.species;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import lcsb.mapviewer.model.map.species.Species;
import lcsb.mapviewer.model.map.species.fields.AssociatedElement;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

@Entity
@DiscriminatorValue(value="Phenotype")
public class Phenotype
extends Species {
    @Cascade(value={CascadeType.ALL})
    @OneToMany(mappedBy="phenotype", orphanRemoval=true)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private List<AssociatedElement> associatedElements = new ArrayList<AssociatedElement>();

    public Phenotype(Species species) {
        super(species);
        if (species instanceof Phenotype) {
            Phenotype phenotype = (Phenotype)species;
            for (AssociatedElement ae : phenotype.getAssociatedElements()) {
                this.addAssociatedElement(new AssociatedElement(ae));
            }
        }
    }

    public Phenotype() {
    }

    @Override
    public Phenotype copy() {
        return new Phenotype(this);
    }

    @Override
    public String getStringType() {
        return "Phenotype";
    }

    public void addAssociatedElement(AssociatedElement ae) {
        this.associatedElements.add(ae);
        ae.setPhenotype(this);
    }

    public List<AssociatedElement> getAssociatedElements() {
        return this.associatedElements;
    }

    public void setAssociatedElements(List<AssociatedElement> associatedElements) {
        this.associatedElements = associatedElements;
    }
}

