/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.species;

import java.util.Comparator;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.map.species.Ion;
import lcsb.mapviewer.model.map.species.SpeciesComparator;

public class IonComparator
implements Comparator<Ion> {
    private double epsilon;

    public IonComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public IonComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(Ion arg0, Ion arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof Ion) {
                return this.internalCompare(arg0, arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        return -1;
    }

    private int internalCompare(Ion arg0, Ion arg1) {
        SpeciesComparator speciesComparator = new SpeciesComparator(this.epsilon);
        int result = speciesComparator.internalCompare(arg0, arg1);
        if (result != 0) {
            return result;
        }
        return 0;
    }
}

