/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.species;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.species.Species;
import org.apache.log4j.Logger;

@Entity
@DiscriminatorValue(value="COMPLEX_SPECIES")
public class ComplexSpecies
extends Species {
    private static Logger logger = Logger.getLogger(ComplexSpecies.class.getName());
    private int homodimer = 1;
    @OneToMany(mappedBy="complex")
    private Set<Element> elements = new HashSet<Element>();
    @Column(name="structuralState")
    private String structuralState = null;

    public ComplexSpecies() {
    }

    public ComplexSpecies(Species original) {
        super(original);
        if (original instanceof ComplexSpecies) {
            this.homodimer = ((ComplexSpecies)original).getHomodimer();
            this.structuralState = ((ComplexSpecies)original).getStructuralState();
            for (Element element : ((ComplexSpecies)original).getElements()) {
                this.addElement(element.copy());
            }
        }
    }

    @Override
    public ComplexSpecies copy() {
        if (this.getClass() == ComplexSpecies.class) {
            return new ComplexSpecies(this);
        }
        throw new InvalidStateException("Method copy() should be overriden in class " + this.getClass());
    }

    @Override
    public String getStringType() {
        return "Complex species";
    }

    public void addElement(Element element) {
        if (element instanceof Species) {
            for (Element el : this.elements) {
                if (!(el instanceof Species) || !((Species)el).getIdSpecies().equals(((Species)element).getIdSpecies())) continue;
                throw new InvalidArgumentException("Cannot add two species with the same id: " + ((Species)el).getIdSpecies());
            }
        }
        this.elements.add(element);
    }

    public Set<Species> getAllSimpleChildren() {
        HashSet<Species> result = new HashSet<Species>();
        for (Element element : this.getElements()) {
            if (element instanceof ComplexSpecies) {
                result.addAll(((ComplexSpecies)element).getAllSimpleChildren());
                continue;
            }
            if (!(element instanceof Species)) continue;
            result.add((Species)element);
        }
        return result;
    }

    public String getStructuralState() {
        return this.structuralState;
    }

    public void setStructuralState(String structuralState) {
        if (this.structuralState != null && !this.structuralState.equals("") && !this.structuralState.equals(structuralState)) {
            logger.warn("replacing structural state, Old: " + this.structuralState + " into new: " + structuralState);
        }
        this.structuralState = structuralState;
    }

    public int getHomodimer() {
        return this.homodimer;
    }

    public void setHomodimer(int homodimer) {
        this.homodimer = homodimer;
    }

    public Set<Element> getElements() {
        return this.elements;
    }

    public void setElements(Set<Element> elements) {
        this.elements = elements;
    }
}

