/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.species;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import lcsb.mapviewer.model.map.species.Species;
import lcsb.mapviewer.model.map.species.fields.AntisenseRnaRegion;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

@Entity
@DiscriminatorValue(value="Antisense RNA")
public class AntisenseRna
extends Species {
    private static Logger logger = Logger.getLogger(AntisenseRna.class);
    @Cascade(value={CascadeType.ALL})
    @OneToMany(mappedBy="species")
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private List<AntisenseRnaRegion> regions = new ArrayList<AntisenseRnaRegion>();

    public AntisenseRna(Species species) {
        super(species);
        if (species instanceof AntisenseRna) {
            AntisenseRna asRna = (AntisenseRna)species;
            for (AntisenseRnaRegion region : asRna.getRegions()) {
                this.addRegion(new AntisenseRnaRegion(region));
            }
        }
    }

    public AntisenseRna() {
    }

    @Override
    public AntisenseRna copy() {
        AntisenseRna result = new AntisenseRna(this);
        return result;
    }

    @Override
    public String getStringType() {
        return "Antisense RNA";
    }

    public void addRegion(AntisenseRnaRegion region) {
        for (AntisenseRnaRegion region2 : this.regions) {
            if (!region2.getIdAntisenseRnaRegion().equals(region.getIdAntisenseRnaRegion())) continue;
            region2.update(region);
            return;
        }
        this.regions.add(region);
        region.setSpecies(this);
    }

    @Override
    public List<String> update(Species sp) {
        List<String> warnings = super.update(sp);
        if (sp instanceof AntisenseRna) {
            AntisenseRna rna = (AntisenseRna)sp;
            for (AntisenseRnaRegion mr : this.getRegions()) {
                mr.setState(null);
            }
            for (AntisenseRnaRegion region : rna.getRegions()) {
                this.updateRegion(region);
            }
        }
        return warnings;
    }

    private void updateRegion(AntisenseRnaRegion param) {
        for (AntisenseRnaRegion region : this.regions) {
            if (!region.getIdAntisenseRnaRegion().equals(param.getIdAntisenseRnaRegion())) continue;
            region.update(param);
            return;
        }
        this.regions.add(param);
    }

    public List<AntisenseRnaRegion> getRegions() {
        return this.regions;
    }

    public void setRegions(List<AntisenseRnaRegion> regions) {
        this.regions = regions;
    }
}

