/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.reaction.type;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.model.map.reaction.Reaction;
import lcsb.mapviewer.model.map.reaction.type.ReactionRect;
import lcsb.mapviewer.model.map.reaction.type.SimpleReactionInterface;

@Entity
@DiscriminatorValue(value="TRANSLATION_REACTION")
public class TranslationReaction
extends Reaction
implements SimpleReactionInterface {
    public TranslationReaction() {
    }

    public TranslationReaction(Reaction result) {
        super(result);
        if (result.getProducts().size() < 1) {
            throw new InvalidArgumentException("Reaction cannot be transformed to " + this.getStringType() + ": number of products must be greater than 0");
        }
        if (result.getReactants().size() < 1) {
            throw new InvalidArgumentException("Reaction cannot be transformed to " + this.getStringType() + ": number of reactants must be greater than 0");
        }
    }

    @Override
    public String getStringType() {
        return "Translation";
    }

    @Override
    public ReactionRect getReactionRect() {
        return ReactionRect.RECT_EMPTY;
    }

    @Override
    public TranslationReaction copy() {
        if (this.getClass() == TranslationReaction.class) {
            return new TranslationReaction(this);
        }
        throw new InvalidStateException("Method copy() should be overriden in class " + this.getClass());
    }
}

