/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.reaction.type;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.model.map.reaction.Reaction;
import lcsb.mapviewer.model.map.reaction.type.ReactionRect;
import lcsb.mapviewer.model.map.reaction.type.SimpleReactionInterface;

@Entity
@DiscriminatorValue(value="PHYSICAL_STIMULATION_REACTION")
public class PhysicalStimulationReaction
extends Reaction
implements SimpleReactionInterface {
    public PhysicalStimulationReaction() {
    }

    public PhysicalStimulationReaction(Reaction result) {
        super(result);
        if (result.getProducts().size() < 1) {
            throw new InvalidArgumentException("Reaction cannot be transformed to " + this.getStringType() + ": number of products must be greater than 0");
        }
        if (result.getReactants().size() < 1) {
            throw new InvalidArgumentException("Reaction cannot be transformed to " + this.getStringType() + ": number of reactants must be greater than 0");
        }
    }

    @Override
    public String getStringType() {
        return "Physical stimulation";
    }

    @Override
    public ReactionRect getReactionRect() {
        return ReactionRect.RECT_EMPTY;
    }

    @Override
    public PhysicalStimulationReaction copy() {
        if (this.getClass() == PhysicalStimulationReaction.class) {
            return new PhysicalStimulationReaction(this);
        }
        throw new InvalidStateException("Method copy() should be overriden in class " + this.getClass());
    }
}

