/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.reaction.type;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.model.map.reaction.Reaction;
import lcsb.mapviewer.model.map.reaction.type.ReactionRect;
import lcsb.mapviewer.model.map.reaction.type.TwoReactantReactionInterface;

@Entity
@DiscriminatorValue(value="HETERODIMER_REACTION")
public class HeterodimerAssociationReaction
extends Reaction
implements TwoReactantReactionInterface {
    public HeterodimerAssociationReaction() {
    }

    public HeterodimerAssociationReaction(Reaction result) {
        super(result);
        if (result.getProducts().size() < 1) {
            throw new InvalidArgumentException("Reaction cannot be transformed to heterodimer association: number of products must be greater than 0");
        }
        if (result.getReactants().size() < 2) {
            throw new InvalidArgumentException("Reaction cannot be transformed to heterodimer association: number of reactants must be greater than 1");
        }
    }

    @Override
    public String getStringType() {
        return "Heterodimer associaation";
    }

    @Override
    public ReactionRect getReactionRect() {
        return ReactionRect.RECT_EMPTY;
    }

    @Override
    public HeterodimerAssociationReaction copy() {
        if (this.getClass() == HeterodimerAssociationReaction.class) {
            return new HeterodimerAssociationReaction(this);
        }
        throw new InvalidStateException("Method copy() should be overriden in class " + this.getClass());
    }
}

