/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.reaction.type;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.model.map.reaction.Reaction;
import lcsb.mapviewer.model.map.reaction.type.ReactionRect;
import lcsb.mapviewer.model.map.reaction.type.TwoReactantReactionInterface;

@Entity
@DiscriminatorValue(value="BOOLEAN_LOGIC_GATE")
public class BooleanLogicGateReaction
extends Reaction
implements TwoReactantReactionInterface {
    public BooleanLogicGateReaction() {
    }

    public BooleanLogicGateReaction(Reaction result) {
        super(result);
        if (result.getProducts().size() < 1) {
            throw new InvalidArgumentException("Reaction cannot be transformed to Boolean logic gate: number of products must be greater than 0");
        }
        if (result.getReactants().size() < 2) {
            throw new InvalidArgumentException("Reaction cannot be transformed to Boolean logic gate: number of reactants must be greater than 1");
        }
    }

    @Override
    public String getStringType() {
        return "Boolean logic gate";
    }

    @Override
    public ReactionRect getReactionRect() {
        return null;
    }

    @Override
    public BooleanLogicGateReaction copy() {
        if (this.getClass() == BooleanLogicGateReaction.class) {
            return new BooleanLogicGateReaction(this);
        }
        throw new InvalidStateException("Method copy() should be overriden in class " + this.getClass());
    }
}

