/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.model;

import java.util.Comparator;
import lcsb.mapviewer.model.map.model.ModelComparator;
import lcsb.mapviewer.model.map.model.ModelSubmodelConnection;
import lcsb.mapviewer.model.map.model.SubmodelConnectionComparator;
import org.apache.log4j.Logger;

public class ModelSubmodelConnectionComparator
implements Comparator<ModelSubmodelConnection> {
    private static Logger logger = Logger.getLogger(ModelSubmodelConnectionComparator.class);
    private double epsilon;

    public ModelSubmodelConnectionComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public ModelSubmodelConnectionComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(ModelSubmodelConnection arg0, ModelSubmodelConnection arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            return this.internalCompare(arg0, arg1);
        }
        logger.debug("class different: " + arg0.getClass() + ", " + arg1.getClass());
        return -1;
    }

    public int internalCompare(ModelSubmodelConnection arg0, ModelSubmodelConnection arg1) {
        SubmodelConnectionComparator superComparator = new SubmodelConnectionComparator(this.epsilon);
        int result = superComparator.internalCompare(arg0, arg1);
        if (result != 0) {
            return result;
        }
        ModelComparator comparator = new ModelComparator(this.epsilon);
        if (arg0.getParentModel() != null && arg1.getParentModel() != null) {
            int status = comparator.compare(arg0.getParentModel().getModel(), arg1.getParentModel().getModel());
            if (status != 0) {
                logger.debug("Model different: " + arg0.getParentModel() + ", " + arg1.getParentModel());
                return status;
            }
        } else {
            if (arg0.getParentModel() != null) {
                logger.debug("Model different: " + arg0.getParentModel() + ", " + arg1.getParentModel());
                return -1;
            }
            if (arg1.getParentModel() != null) {
                logger.debug("Model different: " + arg0.getParentModel() + ", " + arg1.getParentModel());
                return 1;
            }
        }
        return 0;
    }
}

