/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.layout.graphics;

import java.util.Comparator;
import lcsb.mapviewer.common.comparator.ColorComparator;
import lcsb.mapviewer.common.comparator.DoubleComparator;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.map.layout.graphics.LayerRect;

public class LayerRectComparator
implements Comparator<LayerRect> {
    private double epsilon;

    public LayerRectComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public LayerRectComparator() {
        this(1.0E-6);
    }

    private int internalCompare(LayerRect arg0, LayerRect arg1) {
        DoubleComparator doubleComparator = new DoubleComparator(this.epsilon);
        ColorComparator colorComparator = new ColorComparator();
        if (doubleComparator.compare(arg0.getWidth(), arg1.getWidth()) != 0) {
            return doubleComparator.compare(arg0.getWidth(), arg1.getWidth());
        }
        if (doubleComparator.compare(arg0.getHeight(), arg1.getHeight()) != 0) {
            return doubleComparator.compare(arg0.getHeight(), arg1.getHeight());
        }
        if (doubleComparator.compare(arg0.getX(), arg1.getX()) != 0) {
            return doubleComparator.compare(arg0.getX(), arg1.getX());
        }
        if (doubleComparator.compare(arg0.getY(), arg1.getY()) != 0) {
            return doubleComparator.compare(arg0.getY(), arg1.getY());
        }
        if (colorComparator.compare(arg0.getColor(), arg1.getColor()) != 0) {
            return colorComparator.compare(arg0.getColor(), arg1.getColor());
        }
        return 0;
    }

    @Override
    public int compare(LayerRect arg0, LayerRect arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof LayerRect) {
                return this.internalCompare(arg0, arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        return -1;
    }
}

