/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.layout.graphics;

import java.awt.Color;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import lcsb.mapviewer.common.exception.InvalidStateException;
import org.apache.log4j.Logger;

@Entity
public class LayerOval {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="idDb", unique=true, nullable=false)
    private int id;
    private static Logger logger = Logger.getLogger(LayerOval.class);
    private Color color;
    private Double x = 0.0;
    private Double y = 0.0;
    private Double width = 0.0;
    private Double height = 0.0;

    public LayerOval() {
    }

    public LayerOval(LayerOval layerOval) {
        this.color = layerOval.getColor();
        this.x = layerOval.getX();
        this.y = layerOval.getX();
        this.width = layerOval.getWidth();
        this.height = layerOval.getHeight();
    }

    public void setX(String param) {
        try {
            this.x = Double.parseDouble(param);
        }
        catch (Exception e) {
            logger.error("Invalid x value: " + param);
        }
    }

    public void setY(String param) {
        try {
            this.y = Double.parseDouble(param);
        }
        catch (Exception e) {
            logger.error("Invalid y value: " + param);
        }
    }

    public void setWidth(String param) {
        try {
            this.width = Double.parseDouble(param);
        }
        catch (Exception e) {
            logger.error("Invalid width value: " + param);
        }
    }

    public void setHeight(String param) {
        try {
            this.height = Double.parseDouble(param);
        }
        catch (Exception e) {
            logger.error("Invalid height value: " + param);
        }
    }

    public LayerOval copy() {
        if (this.getClass() == LayerOval.class) {
            return new LayerOval(this);
        }
        throw new InvalidStateException("Method copy() should be overriden in class " + this.getClass());
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Double getX() {
        return this.x;
    }

    public void setX(Double x) {
        this.x = x;
    }

    public Double getY() {
        return this.y;
    }

    public void setY(Double y) {
        this.y = y;
    }

    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }
}

