/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.layout.graphics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.model.graphics.PolylineData;
import lcsb.mapviewer.model.map.layout.graphics.LayerOval;
import lcsb.mapviewer.model.map.layout.graphics.LayerRect;
import lcsb.mapviewer.model.map.layout.graphics.LayerText;
import lcsb.mapviewer.model.map.model.ModelData;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.IndexColumn;

@Entity
@Table(name="layer_table")
public class Layer {
    private static Logger logger = Logger.getLogger(Layer.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="idDb", unique=true, nullable=false)
    private int id;
    private String layerId;
    private String name;
    private boolean visible;
    private boolean locked;
    @Cascade(value={CascadeType.ALL})
    @OneToMany(fetch=FetchType.EAGER)
    @IndexColumn(name="idx")
    private List<LayerText> texts = new ArrayList<LayerText>();
    @Cascade(value={CascadeType.ALL})
    @OneToMany(fetch=FetchType.EAGER)
    @IndexColumn(name="idx")
    private List<PolylineData> lines = new ArrayList<PolylineData>();
    @Cascade(value={CascadeType.ALL})
    @OneToMany(fetch=FetchType.EAGER)
    @IndexColumn(name="idx")
    private List<LayerRect> rectangles = new ArrayList<LayerRect>();
    @Cascade(value={CascadeType.ALL})
    @OneToMany(fetch=FetchType.EAGER)
    @IndexColumn(name="idx")
    private List<LayerOval> ovals = new ArrayList<LayerOval>();
    @ManyToOne(fetch=FetchType.LAZY)
    private ModelData model;

    public Layer() {
    }

    public Layer(Layer layer) {
        this.layerId = layer.getLayerId();
        this.name = layer.getName();
        this.visible = layer.isVisible();
        this.locked = layer.isLocked();
        for (LayerText layerText : layer.getTexts()) {
            this.addLayerText(layerText.copy());
        }
        for (PolylineData polylineData : layer.getLines()) {
            this.addLayerLine(polylineData.copy());
        }
        for (LayerRect layerRect : layer.getRectangles()) {
            this.addLayerRect(layerRect.copy());
        }
        for (LayerOval layerOval : layer.getOvals()) {
            this.addLayerOval(layerOval.copy());
        }
        this.model = layer.getModel();
    }

    public Layer copy() {
        if (this.getClass() == Layer.class) {
            return new Layer(this);
        }
        throw new InvalidStateException("Method copy() should be overriden in class " + this.getClass());
    }

    public ModelData getModel() {
        return this.model;
    }

    public void setModel(ModelData model) {
        this.model = model;
    }

    public List<LayerOval> getOvals() {
        return this.ovals;
    }

    public void setOvals(List<LayerOval> ovals) {
        this.ovals = ovals;
    }

    public List<LayerRect> getRectangles() {
        return this.rectangles;
    }

    public void setRectangles(List<LayerRect> rectangles) {
        this.rectangles = rectangles;
    }

    public List<PolylineData> getLines() {
        return this.lines;
    }

    public void setLines(List<PolylineData> lines) {
        this.lines = lines;
    }

    public List<LayerText> getTexts() {
        return this.texts;
    }

    public void setTexts(List<LayerText> texts) {
        this.texts = texts;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLocked(String param) {
        this.locked = param.equalsIgnoreCase("TRUE");
    }

    public void setVisible(String param) {
        this.visible = param.equalsIgnoreCase("TRUE");
    }

    public void addLayerText(LayerText layerText) {
        this.texts.add(layerText);
    }

    public void addLayerRect(LayerRect layerRect) {
        this.rectangles.add(layerRect);
    }

    public void addLayerOval(LayerOval layerOval) {
        this.ovals.add(layerOval);
    }

    public void addLayerLine(PolylineData layerLine) {
        this.lines.add(layerLine);
    }

    public String getLayerId() {
        return this.layerId;
    }

    public void setLayerId(String layerId) {
        this.layerId = layerId;
    }

    public void addLayerLines(Collection<PolylineData> lines) {
        for (PolylineData layerLine : lines) {
            this.addLayerLine(layerLine);
        }
    }
}

