/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.layout.alias;

import java.util.Comparator;
import java.util.HashMap;
import lcsb.mapviewer.common.comparator.IntegerComparator;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import lcsb.mapviewer.model.map.layout.alias.AliasComparator;
import lcsb.mapviewer.model.map.layout.alias.ComplexAlias;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAliasComparator;
import org.apache.log4j.Logger;

public class ComplexAliasComparator
implements Comparator<ComplexAlias> {
    private static Logger logger = Logger.getLogger(ComplexAliasComparator.class);
    private double epsilon;

    public ComplexAliasComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public ComplexAliasComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(ComplexAlias arg0, ComplexAlias arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof ComplexAlias) {
                return this.internalCompare(arg0, arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        return -1;
    }

    private int internalCompare(ComplexAlias arg0, ComplexAlias arg1) {
        Alias alias2;
        SpeciesAliasComparator speciesAliasComparator = new SpeciesAliasComparator(this.epsilon);
        AliasComparator aliasComparator = new AliasComparator(this.epsilon);
        int result = speciesAliasComparator.internalCompare(arg0, arg1);
        if (result != 0) {
            return result;
        }
        IntegerComparator integerComparator = new IntegerComparator();
        if (integerComparator.compare(arg0.getAliases().size(), arg1.getAliases().size()) != 0) {
            logger.debug("children aliases size different: " + arg0.getAliases().size() + ", " + arg1.getAliases().size());
            return integerComparator.compare(arg0.getAliases().size(), arg1.getAliases().size());
        }
        HashMap<String, Alias> map1 = new HashMap<String, Alias>();
        HashMap<String, Alias> map2 = new HashMap<String, Alias>();
        for (Alias alias : arg0.getAliases()) {
            if (map1.get(alias.getAliasId()) != null) {
                for (Alias alias3 : arg0.getAliases()) {
                    logger.debug(alias3.getAliasId());
                }
                throw new InvalidArgumentException("Few aliases with the same id: " + alias.getAliasId());
            }
            map1.put(alias.getAliasId(), alias);
        }
        for (Alias alias : arg1.getAliases()) {
            if (map2.get(alias.getAliasId()) != null) {
                throw new InvalidArgumentException("Few aliases with the same id: " + alias.getAliasId());
            }
            map2.put(alias.getAliasId(), alias);
        }
        for (Alias alias : arg0.getAliases()) {
            int n = aliasComparator.compare(alias, alias2 = (Alias)map2.get(alias.getAliasId()));
            if (n == 0) continue;
            logger.debug("child doesn't have a match: " + alias.getAliasId());
            return n;
        }
        for (Alias alias : arg1.getAliases()) {
            alias2 = (Alias)map1.get(alias.getAliasId());
            int n = aliasComparator.compare(alias2, alias);
            if (n == 0) continue;
            logger.debug("child doesn't have a match: " + alias.getAliasId());
            return n;
        }
        return 0;
    }
}

