/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.layout.alias;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAlias;
import lcsb.mapviewer.model.map.species.ComplexSpecies;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@DiscriminatorValue(value="Complex Species Alias")
public class ComplexAlias
extends SpeciesAlias {
    private static Logger logger = Logger.getLogger(ComplexAlias.class);
    @Cascade(value={CascadeType.ALL})
    @OneToMany(fetch=FetchType.EAGER, mappedBy="complexAlias")
    private List<SpeciesAlias> aliases = new ArrayList<SpeciesAlias>();

    public ComplexAlias() {
    }

    public ComplexAlias(ComplexAlias original) {
        super(original);
        for (SpeciesAlias alias : original.getAliases()) {
            this.addAlias(alias.copy());
        }
    }

    public ComplexAlias(ComplexSpecies species) {
        this();
        this.setSpecies(species);
    }

    public void addAlias(SpeciesAlias alias) {
        boolean contains = false;
        for (SpeciesAlias alias2 : this.aliases) {
            if (!alias.getAliasId().equals(alias2.getAliasId())) continue;
            contains = true;
        }
        if (!contains) {
            this.aliases.add(alias);
            alias.setComplexAlias(this);
        }
    }

    public List<SpeciesAlias> getAliases() {
        return this.aliases;
    }

    public List<SpeciesAlias> getAllChildrenAliases() {
        ArrayList<SpeciesAlias> result = new ArrayList<SpeciesAlias>();
        result.addAll(this.aliases);
        for (SpeciesAlias speciesAlias : this.aliases) {
            if (!(speciesAlias instanceof ComplexAlias)) continue;
            result.addAll(((ComplexAlias)speciesAlias).getAllChildrenAliases());
        }
        return result;
    }

    @Override
    public ComplexAlias copy() {
        if (this.getClass() == ComplexAlias.class) {
            return new ComplexAlias(this);
        }
        throw new InvalidStateException("Method copy() should be overriden in class " + this.getClass());
    }

    public void removeAlias(SpeciesAlias alias) {
        this.aliases.remove(alias);
        alias.setComplexAlias(null);
    }
}

