/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.layout.alias;

import java.util.Comparator;
import java.util.HashMap;
import lcsb.mapviewer.common.comparator.DoubleComparator;
import lcsb.mapviewer.common.comparator.IntegerComparator;
import lcsb.mapviewer.common.comparator.PointComparator;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.map.agregator.CompartmentComparator;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import lcsb.mapviewer.model.map.layout.alias.AliasComparator;
import lcsb.mapviewer.model.map.layout.alias.CompartmentAlias;
import org.apache.log4j.Logger;

public class CompartmentAliasComparator
implements Comparator<CompartmentAlias> {
    private Logger logger = Logger.getLogger(CompartmentAliasComparator.class);
    private double epsilon;

    public CompartmentAliasComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public CompartmentAliasComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(CompartmentAlias arg0, CompartmentAlias arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof CompartmentAlias) {
                return this.internalCompare(arg0, arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        return -1;
    }

    private int internalCompare(CompartmentAlias arg0, CompartmentAlias arg1) {
        int status;
        Alias alias2;
        AliasComparator aliasComparator = new AliasComparator(this.epsilon);
        int result = aliasComparator.internalCompare(arg0, arg1);
        if (result != 0) {
            return result;
        }
        DoubleComparator doubleComparator = new DoubleComparator(this.epsilon);
        IntegerComparator integerComparator = new IntegerComparator();
        PointComparator pointComparator = new PointComparator(this.epsilon);
        if (doubleComparator.compare(arg0.getThickness(), arg1.getThickness()) != 0) {
            this.logger.debug("Thickness different: " + arg0.getThickness() + ", " + arg1.getThickness());
            return doubleComparator.compare(arg0.getThickness(), arg1.getThickness());
        }
        if (doubleComparator.compare(arg0.getOuterWidth(), arg1.getOuterWidth()) != 0) {
            this.logger.debug("Outer width different: " + arg0.getOuterWidth() + ", " + arg1.getOuterWidth());
            return doubleComparator.compare(arg0.getOuterWidth(), arg1.getOuterWidth());
        }
        if (doubleComparator.compare(arg0.getInnerWidth(), arg1.getInnerWidth()) != 0) {
            this.logger.debug("Inner width different: " + arg0.getInnerWidth() + ", " + arg1.getInnerWidth());
            return doubleComparator.compare(arg0.getInnerWidth(), arg1.getInnerWidth());
        }
        if (pointComparator.compare(arg0.getNamePoint(), arg1.getNamePoint()) != 0) {
            this.logger.debug("NamePoint different: " + arg0.getNamePoint() + ", " + arg1.getNamePoint());
            return pointComparator.compare(arg0.getNamePoint(), arg1.getNamePoint());
        }
        CompartmentComparator cComparator = new CompartmentComparator(this.epsilon);
        if (cComparator.compare(arg0.getCompartment(), arg1.getCompartment()) != 0) {
            this.logger.debug("Compartment different");
            return cComparator.compare(arg0.getCompartment(), arg1.getCompartment());
        }
        if (integerComparator.compare(arg0.getAliases().size(), arg1.getAliases().size()) != 0) {
            this.logger.debug("Aliases number different: " + arg0.getAliases().size() + ", " + arg1.getAliases().size());
            return integerComparator.compare(arg0.getAliases().size(), arg1.getAliases().size());
        }
        HashMap<String, Alias> map1 = new HashMap<String, Alias>();
        HashMap<String, Alias> map2 = new HashMap<String, Alias>();
        for (Alias alias : arg0.getAliases()) {
            if (map1.get(alias.getAliasId()) != null) {
                throw new InvalidArgumentException("Few aliases with the same id: " + alias.getAliasId());
            }
            map1.put(alias.getAliasId(), alias);
        }
        for (Alias alias : arg1.getAliases()) {
            if (map2.get(alias.getAliasId()) != null) {
                throw new InvalidArgumentException("Few aliases with the same id: " + alias.getAliasId());
            }
            map2.put(alias.getAliasId(), alias);
        }
        for (Alias alias : arg0.getAliases()) {
            status = aliasComparator.compare(alias, alias2 = (Alias)map2.get(alias.getAliasId()));
            if (status == 0) continue;
            this.logger.debug("Couldn't match alias: " + alias.getAliasId() + ", " + alias2);
            return status;
        }
        for (Alias alias : arg1.getAliases()) {
            alias2 = (Alias)map1.get(alias.getAliasId());
            status = aliasComparator.compare(alias2, alias);
            if (status == 0) continue;
            this.logger.debug("Couldn't match alias: " + alias.getAliasId() + ", " + alias2);
            return status;
        }
        return 0;
    }
}

