/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.layout.alias;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.model.map.agregator.Compartment;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import lcsb.mapviewer.model.map.layout.alias.ComplexAlias;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAlias;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Type;

@Entity
@DiscriminatorValue(value="Compartment Alias")
public class CompartmentAlias
extends Alias {
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private static final int DEFAULT_INNER_BORDER_WIDTH = 1;
    private static final int DEFAULT_OUTER_BORDER_WIDTH = 2;
    private static final int DEFAULT_COMPARTMENT_THICKNESS = 12;
    private static Logger logger = Logger.getLogger(CompartmentAlias.class.getName());
    private double thickness;
    private double outerWidth;
    private double innerWidth;
    @Type(type="lcsb.mapviewer.persist.mapper.Point2DMapper")
    private Point2D namePoint;
    @Cascade(value={CascadeType.ALL})
    @OneToMany(fetch=FetchType.EAGER, mappedBy="compartmentAlias")
    private Set<Alias> aliases;

    public CompartmentAlias(CompartmentAlias original) {
        super(original);
        this.namePoint = new Point2D.Double();
        this.namePoint.setLocation(original.getNamePoint());
        this.thickness = original.thickness;
        this.outerWidth = original.outerWidth;
        this.innerWidth = original.innerWidth;
        this.aliases = new HashSet<Alias>();
        for (Alias alias : original.aliases) {
            this.addAlias(alias.copy());
        }
    }

    public CompartmentAlias() {
        this.namePoint = new Point2D.Double(0.0, 0.0);
        this.thickness = 12.0;
        this.outerWidth = 2.0;
        this.innerWidth = 1.0;
        this.setColor(DEFAULT_COLOR);
        this.aliases = new HashSet<Alias>();
    }

    public CompartmentAlias(Compartment compartment) {
        this();
        this.setCompartment(compartment);
    }

    public void setLineThickness(String text) {
        try {
            this.thickness = Double.parseDouble(text);
        }
        catch (Exception e) {
            this.thickness = 12.0;
            logger.error("Invalid thickness format: " + text);
        }
    }

    public void setLineOuterWidth(String text) {
        try {
            this.outerWidth = Double.parseDouble(text);
        }
        catch (Exception e) {
            this.outerWidth = 12.0;
            logger.error("Invalid outerWidth format: " + text);
        }
    }

    public void setLineInnerWidth(String text) {
        try {
            this.innerWidth = Double.parseDouble(text);
        }
        catch (Exception e) {
            this.innerWidth = 12.0;
            logger.error("Invalid innerWidth format: " + text);
        }
    }

    public void addAlias(Alias aliasToAdd) {
        for (Alias alias : this.aliases) {
            if (!alias.getAliasId().equals(aliasToAdd.getAliasId())) continue;
            if (alias.equals(aliasToAdd)) {
                return;
            }
            throw new InvalidArgumentException("Alias " + aliasToAdd.getAliasId() + " already on the list of compartment " + this.getAliasId() + " children");
        }
        this.aliases.add(aliasToAdd);
        aliasToAdd.setCompartmentAlias(this);
    }

    public Set<Alias> getAllSubAliases() {
        HashSet<Alias> result = new HashSet<Alias>();
        result.addAll(this.getAliases());
        for (Alias abstractAlias : this.getAliases()) {
            if (!(abstractAlias instanceof CompartmentAlias)) continue;
            result.addAll(((CompartmentAlias)abstractAlias).getAllSubAliases());
        }
        return result;
    }

    public boolean cross(Alias alias2) {
        HashSet<Alias> parents = new HashSet<Alias>();
        while (alias2.getParent() != null && alias2.getParent() instanceof ComplexAlias) {
            if (parents.contains(alias2 = alias2.getParent())) {
                throw new InvalidStateException("Cycled nesting in complex parents: " + alias2.getElement().getName());
            }
            parents.add(alias2);
        }
        Point2D.Double argumentTopLeftCorner = new Point2D.Double(alias2.getX(), alias2.getY());
        Point2D.Double argumentBottomRightCorner = new Point2D.Double(alias2.getX() + alias2.getWidth(), alias2.getY() + alias2.getHeight());
        Point2D.Double topLeftCorner = new Point2D.Double(this.getX(), this.getY());
        Point2D.Double bottomRightCorner = new Point2D.Double(this.getX() + this.getWidth(), this.getY() + this.getHeight());
        return ((Point2D)argumentTopLeftCorner).getX() < ((Point2D)bottomRightCorner).getX() && ((Point2D)argumentTopLeftCorner).getY() < ((Point2D)bottomRightCorner).getY() && ((Point2D)argumentBottomRightCorner).getX() > ((Point2D)topLeftCorner).getX() && ((Point2D)argumentBottomRightCorner).getY() > ((Point2D)topLeftCorner).getY();
    }

    public String getTitle() {
        if (this.getCompartment() != null) {
            return this.getCompartment().getName();
        }
        return null;
    }

    public boolean containsIdenticalSpecies() {
        for (Alias a : this.aliases) {
            String name;
            if (!(a instanceof SpeciesAlias) || !(name = a.getElement().getName()).equalsIgnoreCase(this.getTitle())) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompartmentAlias copy() {
        if (this.getClass() == CompartmentAlias.class) {
            return new CompartmentAlias(this);
        }
        throw new InvalidStateException("Method copy() should be overriden in class " + this.getClass());
    }

    public void removeAlias(Alias alias) {
        this.aliases.remove(alias);
        alias.setCompartmentAlias(null);
    }

    public void setNamePoint(double x, double y) {
        this.setNamePoint(new Point2D.Double(x, y));
    }

    public boolean containPoint(Point2D point) {
        return this.getX() <= point.getX() && this.getX() + this.getWidth() >= point.getX() && this.getY() <= point.getY() && this.getY() + this.getHeight() >= point.getY();
    }

    public void setAliases(Set<Alias> aliases) {
        this.aliases = aliases;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public double getOuterWidth() {
        return this.outerWidth;
    }

    public void setOuterWidth(double outerWidth) {
        this.outerWidth = outerWidth;
    }

    public double getInnerWidth() {
        return this.innerWidth;
    }

    public void setInnerWidth(double innerWidth) {
        this.innerWidth = innerWidth;
    }

    public Point2D getNamePoint() {
        return this.namePoint;
    }

    public void setNamePoint(Point2D namePoint) {
        this.namePoint = namePoint;
    }

    public Compartment getCompartment() {
        return (Compartment)this.getElement();
    }

    public void setCompartment(Compartment compartment) {
        this.setElement(compartment);
    }

    public Set<Alias> getAliases() {
        return this.aliases;
    }
}

