/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.layout;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.model.map.layout.LayoutStatus;
import lcsb.mapviewer.model.map.model.ModelData;
import lcsb.mapviewer.model.user.User;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
public class Layout {
    private static Logger logger = Logger.getLogger(Layout.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="idDb", unique=true, nullable=false)
    private int id;
    private String directory;
    private String title;
    private boolean publicLayout = false;
    private boolean hierarchicalView = false;
    @ManyToOne(fetch=FetchType.LAZY)
    private ModelData model;
    @ManyToOne(fetch=FetchType.LAZY)
    private User creator;
    private LayoutStatus status = LayoutStatus.UNKNOWN;
    private double progress = 0.0;
    @Cascade(value={CascadeType.ALL})
    @OneToMany(fetch=FetchType.EAGER, mappedBy="parentLayout", orphanRemoval=true)
    private Set<Layout> layouts = new HashSet<Layout>();
    @ManyToOne(fetch=FetchType.LAZY)
    private Layout parentLayout = null;
    @Column(columnDefinition="TEXT")
    private String description;

    public Layout() {
    }

    public Layout(String title, String directory, boolean publicLayout) {
        this.title = title;
        this.directory = directory;
        this.publicLayout = publicLayout;
    }

    public Layout(Layout layout) {
        this.directory = layout.getDirectory();
        this.title = layout.getTitle();
        this.publicLayout = layout.publicLayout;
        this.status = layout.status;
        this.progress = layout.progress;
        this.hierarchicalView = layout.hierarchicalView;
    }

    public Layout copy() {
        if (this.getClass() == Layout.class) {
            return new Layout(this);
        }
        throw new InvalidStateException("Method copy() should be overriden in class " + this.getClass());
    }

    public boolean isHierarchicalView() {
        return this.hierarchicalView;
    }

    public void setHierarchicalView(boolean hierarchicalView) {
        this.hierarchicalView = hierarchicalView;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isPublicLayout() {
        return this.publicLayout;
    }

    public void setPublicLayout(boolean publicLayout) {
        this.publicLayout = publicLayout;
    }

    public ModelData getModel() {
        return this.model;
    }

    public void setModel(ModelData model) {
        this.model = model;
    }

    public User getCreator() {
        return this.creator;
    }

    public void setCreator(User creator) {
        this.creator = creator;
    }

    public LayoutStatus getStatus() {
        return this.status;
    }

    public void setStatus(LayoutStatus status) {
        this.status = status;
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<Layout> getLayouts() {
        return this.layouts;
    }

    public void setLayouts(Set<Layout> layouts) {
        this.layouts = layouts;
    }

    public Layout getParentLayout() {
        return this.parentLayout;
    }

    public void setParentLayout(Layout parentLayout) {
        this.parentLayout = parentLayout;
    }

    public void addLayout(Layout layout) {
        this.layouts.add(layout);
        layout.setParentLayout(this);
    }
}

