/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.graph;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.MiriamData;
import lcsb.mapviewer.model.map.graph.DataMiningType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.IndexColumn;

@Entity
public class DataMining {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="idDb", unique=true, nullable=false)
    private Integer id;
    @ManyToOne(optional=false)
    private Element element;
    @Cascade(value={CascadeType.ALL})
    @OneToMany(fetch=FetchType.EAGER)
    @IndexColumn(name="idx")
    @JoinTable(name="datamining_suggested_connections")
    private List<MiriamData> suggestedConnections = new ArrayList<MiriamData>();
    @Column(columnDefinition="TEXT")
    private String description;
    private DataMiningType type;
    @Cascade(value={CascadeType.ALL})
    @OneToMany(fetch=FetchType.EAGER)
    @IndexColumn(name="idx")
    private List<MiriamData> references = new ArrayList<MiriamData>();

    public void addReference(MiriamData md) {
        this.references.add(md);
    }

    public List<MiriamData> getReferences() {
        return this.references;
    }

    public void setReferences(List<MiriamData> references) {
        this.references = references;
    }

    public DataMiningType getType() {
        return this.type;
    }

    public void setType(DataMiningType type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public List<MiriamData> getSuggestedConnections() {
        return this.suggestedConnections;
    }

    public void setSuggestedConnections(List<MiriamData> suggestedConnections) {
        this.suggestedConnections = suggestedConnections;
    }

    public void addSuggestedConnection(MiriamData suggestedConnection) {
        this.suggestedConnections.add(suggestedConnection);
    }
}

