/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.agregator;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.model.map.Element;
import org.apache.log4j.Logger;

@Entity
@DiscriminatorValue(value="Compartment")
public class Compartment
extends Element
implements Comparable<Compartment> {
    private static Logger logger = Logger.getLogger(Compartment.class);
    @Column(name="compartmentId")
    private String compartmentId = "";
    @OneToMany(mappedBy="parent")
    private Set<Element> elements = new HashSet<Element>();

    public Compartment(String id) {
        this.compartmentId = id;
    }

    public Compartment() {
    }

    public Compartment(Compartment compartment) {
        super(compartment);
        this.setCompartmentId(compartment.getCompartmentId());
        this.setMetaId(compartment.getMetaId());
        for (Element element : compartment.getElements()) {
            this.addElement(element.copy());
        }
    }

    @Override
    public int compareTo(Compartment param) {
        if (param == null) {
            return -1;
        }
        if (!this.compartmentId.equals(param.getCompartmentId())) {
            return this.compartmentId.compareTo(param.getCompartmentId());
        }
        if (!this.getName().equals(param.getName())) {
            return this.getName().compareTo(param.getName());
        }
        return 0;
    }

    public boolean equals(Object param) {
        if (this == param) {
            return true;
        }
        if (!(param instanceof Compartment)) {
            return false;
        }
        return this.compareTo((Compartment)param) == 0;
    }

    public int hashCode() {
        String result = this.compartmentId + "_" + this.getName();
        return result.hashCode();
    }

    @Override
    public Compartment copy() {
        if (this.getClass() != Compartment.class) {
            throw new InvalidStateException("this method should be overloaded");
        }
        return new Compartment(this);
    }

    @Override
    public String getElementId() {
        return this.getCompartmentId();
    }

    @Override
    public String getStringType() {
        return "Compartment";
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public void setCompartmentId(String compartmentId) {
        this.compartmentId = compartmentId;
    }

    public void addElement(Element element) {
        this.elements.add(element);
        element.setParent(this);
    }

    public Set<Element> getElements() {
        return this.elements;
    }
}

