/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.MiriamRelationType;
import lcsb.mapviewer.model.map.MiriamType;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="miriam_data_table")
@GenericGenerator(name="test-increment-strategy", strategy="increment")
public class MiriamData
implements Comparable<MiriamData> {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="idDb", unique=true, nullable=false)
    private int id;
    private MiriamRelationType relationType = null;
    @Enumerated(value=EnumType.STRING)
    private MiriamType dataType;
    @Column(name="resource")
    private String resource = "";
    @ManyToOne(fetch=FetchType.LAZY)
    private Element element;

    public MiriamData() {
    }

    public MiriamData(MiriamData md) {
        this.setRelationType(md.relationType);
        this.setDataType(md.dataType);
        this.setResource(md.resource);
    }

    public MiriamData(MiriamRelationType relationType, MiriamType mt, String resource) {
        if (mt == null) {
            throw new InvalidArgumentException("MiriamType cannot be null");
        }
        if (relationType == null) {
            throw new InvalidArgumentException("MiriamRelationType cannot be null");
        }
        this.setRelationType(relationType);
        this.setDataType(mt);
        this.setResource(resource);
    }

    public MiriamData(MiriamType mt, String resource) {
        this(MiriamRelationType.BQ_BIOL_IS_DESCRIBED_BY, mt, resource);
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource == null ? null : resource.replace("%3A", ":");
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof MiriamData)) {
            return false;
        }
        MiriamData that = (MiriamData)aThat;
        return this.dataType.equals((Object)that.getDataType()) && this.resource.equals(that.getResource());
    }

    public int hashCode() {
        return ((Object)((Object)this.dataType) + this.resource).hashCode();
    }

    @Override
    public int compareTo(MiriamData other) {
        return ((Object)((Object)this.dataType) + ":" + this.resource).compareTo((Object)((Object)other.dataType) + ":" + other.resource);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public MiriamType getDataType() {
        return this.dataType;
    }

    public void setDataType(MiriamType dataType) {
        this.dataType = dataType;
    }

    public MiriamRelationType getRelationType() {
        return this.relationType;
    }

    public void setRelationType(MiriamRelationType relationType) {
        this.relationType = relationType;
    }

    public String toString() {
        return "[" + this.relationType.getStringRepresentation() + "] " + (Object)((Object)this.dataType) + ":" + this.resource;
    }
}

