/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import lcsb.mapviewer.common.comparator.StringComparator;
import lcsb.mapviewer.common.comparator.StringListComparator;
import lcsb.mapviewer.common.comparator.StringSetComparator;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.MiriamData;
import lcsb.mapviewer.model.map.agregator.Compartment;
import lcsb.mapviewer.model.map.agregator.CompartmentComparator;
import lcsb.mapviewer.model.map.species.Species;
import lcsb.mapviewer.model.map.species.SpeciesComparator;
import org.apache.log4j.Logger;

public class ElementComparator
implements Comparator<Element> {
    private static Logger logger = Logger.getLogger(ElementComparator.class);
    private double epsilon;

    public ElementComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public ElementComparator() {
        this(1.0E-6);
    }

    public int internalCompare(Element arg0, Element arg1) {
        String hash;
        StringComparator stringComparator = new StringComparator();
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (stringComparator.compare(arg0.getName(), arg1.getName()) != 0) {
            logger.debug("Name different: " + arg0.getName() + ", " + arg1.getName());
            return stringComparator.compare(arg0.getName(), arg1.getName());
        }
        if (stringComparator.compare(arg0.getNotes(), arg1.getNotes(), true) != 0) {
            logger.debug("notes different: \n\"" + arg0.getNotes() + "\"\n\"" + arg1.getNotes() + "\"");
            return stringComparator.compare(arg0.getNotes(), arg1.getNotes());
        }
        if (stringComparator.compare(arg0.getSymbol(), arg1.getSymbol()) != 0) {
            logger.debug("symbol different: \"" + arg0.getSymbol() + "\", \"" + arg1.getSymbol() + "\"");
            return stringComparator.compare(arg0.getSymbol(), arg1.getSymbol());
        }
        if (stringComparator.compare(arg0.getFullName(), arg1.getFullName()) != 0) {
            logger.debug("full name different: \"" + arg0.getSymbol() + "\", \"" + arg1.getFullName() + "\"");
            return stringComparator.compare(arg0.getFullName(), arg1.getFullName());
        }
        if (stringComparator.compare(arg0.getAbbreviation(), arg1.getAbbreviation()) != 0) {
            logger.debug("Abbreviation different: \"" + arg0.getAbbreviation() + "\", \"" + arg1.getAbbreviation() + "\"");
            return stringComparator.compare(arg0.getAbbreviation(), arg1.getAbbreviation());
        }
        if (stringComparator.compare(arg0.getFormula(), arg1.getFormula()) != 0) {
            logger.debug("formula different: \"" + arg0.getFormula() + "\", \"" + arg1.getFormula() + "\"");
            return stringComparator.compare(arg0.getFormula(), arg1.getFormula());
        }
        StringSetComparator stringSetComparator = new StringSetComparator();
        StringListComparator stringListComparator = new StringListComparator();
        if (stringListComparator.compare(arg0.getSynonyms(), arg1.getSynonyms()) != 0) {
            logger.debug("List of synonyms different");
            return stringListComparator.compare(arg0.getSynonyms(), arg1.getSynonyms());
        }
        if (stringListComparator.compare(arg0.getFormerSymbols(), arg1.getFormerSymbols()) != 0) {
            logger.debug("List of former symbols different");
            return stringListComparator.compare(arg0.getFormerSymbols(), arg1.getFormerSymbols());
        }
        HashSet<String> hashCode1 = new HashSet<String>();
        HashSet<String> hashCode2 = new HashSet<String>();
        if (arg0.getMiriamData().size() != arg1.getMiriamData().size()) {
            logger.debug("different number of annotations: " + arg0.getMiriamData().size() + ", " + arg1.getMiriamData().size());
            return Integer.valueOf(arg0.getMiriamData().size()).compareTo(arg1.getMiriamData().size());
        }
        for (MiriamData md : arg0.getMiriamData()) {
            hash = (Object)((Object)md.getRelationType()) + "  " + (Object)((Object)md.getDataType()) + "  " + md.getResource();
            hashCode1.add(hash);
        }
        for (MiriamData md : arg1.getMiriamData()) {
            hash = (Object)((Object)md.getRelationType()) + "  " + (Object)((Object)md.getDataType()) + "  " + md.getResource();
            hashCode2.add(hash);
        }
        if (stringSetComparator.compare((Set<String>)hashCode1, (Set<String>)hashCode2) != 0) {
            logger.debug("different annotations: ");
            logger.debug("A:");
            for (String string : hashCode1) {
                logger.debug("|" + string + "|");
            }
            logger.debug("B:");
            for (String string : hashCode2) {
                logger.debug("|" + string + "|");
            }
            logger.debug("--");
            return stringSetComparator.compare((Set<String>)hashCode1, (Set<String>)hashCode2);
        }
        return 0;
    }

    @Override
    public int compare(Element arg0, Element arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof Species) {
                SpeciesComparator speciesComparator = new SpeciesComparator(this.epsilon);
                return speciesComparator.compare((Species)arg0, (Species)arg1);
            }
            if (arg0 instanceof Compartment) {
                CompartmentComparator compartmentComparator = new CompartmentComparator(this.epsilon);
                return compartmentComparator.compare((Compartment)arg0, (Compartment)arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        return -1;
    }
}

