/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.graphics;

import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import lcsb.mapviewer.common.exception.NotImplementedException;
import lcsb.mapviewer.model.graphics.ArrowTypeData;
import lcsb.mapviewer.model.graphics.LineType;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.Type;

@Entity
public class PolylineData {
    private static Logger logger = Logger.getLogger(PolylineData.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="idDb", unique=true, nullable=false)
    private int id;
    @ElementCollection
    @CollectionTable(name="point_table", joinColumns={@JoinColumn(name="idDb")})
    @IndexColumn(name="idx")
    @Column(name="point_val")
    @Type(type="lcsb.mapviewer.persist.mapper.Point2DMapper")
    @Cascade(value={CascadeType.ALL})
    private List<Point2D> points = new ArrayList<Point2D>();
    @Cascade(value={CascadeType.ALL})
    @OneToOne
    private ArrowTypeData beginAtd = new ArrowTypeData();
    @Cascade(value={CascadeType.ALL})
    @OneToOne
    private ArrowTypeData endAtd = new ArrowTypeData();
    private double width = 1.0;
    private Color color = Color.BLACK;
    private LineType type = LineType.SOLID;

    public PolylineData(Point2D startPoint, Point2D endPoint) {
        this.points.add(startPoint);
        this.points.add(endPoint);
    }

    public PolylineData() {
    }

    public PolylineData(PolylineData param) {
        this.points = new ArrayList<Point2D>();
        for (Point2D point : param.getPoints()) {
            this.points.add(new Point2D.Double(point.getX(), point.getY()));
        }
        this.beginAtd = new ArrowTypeData(param.getBeginAtd());
        this.endAtd = new ArrowTypeData(param.getEndAtd());
        this.width = param.getWidth();
        this.color = param.getColor();
        this.type = param.getType();
    }

    public PolylineData(List<Point2D> pointsList) {
        this.points.addAll(pointsList);
    }

    public void addPoint(Point2D point) {
        this.points.add(point);
    }

    public void setPoint(int position, Point2D point) {
        this.points.set(position, point);
    }

    public List<Line2D> getLines() {
        ArrayList<Line2D> result = new ArrayList<Line2D>();
        if (this.points.size() > 1) {
            Point2D p1 = this.points.get(0);
            for (int i = 1; i < this.points.size(); ++i) {
                Point2D p2 = this.points.get(i);
                Line2D.Double line = new Line2D.Double(p1, p2);
                result.add(line);
                p1 = p2;
            }
        }
        return result;
    }

    public PolylineData getSubline(int from, int to) {
        PolylineData result = new PolylineData(this);
        result.setPoints(new ArrayList<Point2D>());
        for (int i = Math.max(from, 0); i < Math.min(to, this.points.size()); ++i) {
            result.addPoint(new Point2D.Double(this.points.get(i).getX(), this.points.get(i).getY()));
        }
        return result;
    }

    public void setEndPoint(Point2D point) {
        this.points.set(this.points.size() - 1, point);
    }

    public Point2D getEndPoint() {
        return this.points.get(this.points.size() - 1);
    }

    public GeneralPath toGeneralPath() {
        GeneralPath path = new GeneralPath();
        Point2D p = this.points.get(0);
        path.moveTo(p.getX(), p.getY());
        for (int i = 1; i < this.points.size(); ++i) {
            p = this.points.get(i);
            path.lineTo(p.getX(), p.getY());
        }
        return path;
    }

    public void trimEnd(double distToTrim) {
        Point2D last2;
        Point2D last = this.points.get(this.points.size() - 1);
        double oldDist = last.distance(last2 = this.points.get(this.points.size() - 2));
        if (oldDist <= distToTrim) {
            last.setLocation(last2);
        } else {
            double newDistr = oldDist - distToTrim;
            double ratio = newDistr / oldDist;
            double dx = last.getX() - last2.getX();
            double dy = last.getY() - last2.getY();
            last.setLocation(last2.getX() + (dx *= ratio), last2.getY() + (dy *= ratio));
        }
        oldDist = last.distance(last2);
    }

    public void trimBegin(double distToTrim) {
        Point2D last2;
        Point2D last = this.points.get(0);
        double oldDist = last.distance(last2 = this.points.get(1));
        if (oldDist <= distToTrim) {
            last.setLocation(last2);
        } else {
            double newDistr = oldDist - distToTrim;
            double ratio = newDistr / oldDist;
            double dx = last.getX() - last2.getX();
            double dy = last.getY() - last2.getY();
            last.setLocation(last2.getX() + (dx *= ratio), last2.getY() + (dy *= ratio));
        }
    }

    public PolylineData reverse() {
        PolylineData result = new PolylineData(this);
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (int i = this.getPoints().size() - 1; i >= 0; --i) {
            points.add(this.getPoints().get(i));
        }
        result.setPoints(points);
        result.setBeginAtd(this.getEndAtd());
        result.setEndAtd(this.getBeginAtd());
        return result;
    }

    public double length() {
        if (this.points.size() < 2) {
            return 0.0;
        }
        double dist = 0.0;
        Point2D point = this.points.get(0);
        for (int i = 1; i < this.points.size(); ++i) {
            dist += point.distance(this.points.get(i));
            point = this.points.get(i);
        }
        return dist;
    }

    public void setStartPoint(Point2D startPoint) {
        this.points.set(0, startPoint);
    }

    public Point2D getBeginPoint() {
        return this.points.get(0);
    }

    public List<Point2D> getPoints() {
        return this.points;
    }

    public void setPoints(List<Point2D> points) {
        this.points = points;
    }

    public ArrowTypeData getBeginAtd() {
        return this.beginAtd;
    }

    public void setBeginAtd(ArrowTypeData beginAtd) {
        this.beginAtd = beginAtd;
    }

    public ArrowTypeData getEndAtd() {
        return this.endAtd;
    }

    public void setEndAtd(ArrowTypeData endAtd) {
        this.endAtd = endAtd;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public LineType getType() {
        return this.type;
    }

    public void setType(LineType type) {
        this.type = type;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setWidth(String string) {
        Double.parseDouble(string);
    }

    public PolylineData copy() {
        if (this.getClass().equals(PolylineData.class)) {
            return new PolylineData(this);
        }
        throw new NotImplementedException("Copy method for " + this.getClass() + " class not implemented.");
    }
}

