/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.types;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.geometry.PointTransformation;
import lcsb.mapviewer.converter.model.celldesigner.types.ModifierType;
import lcsb.mapviewer.model.graphics.PolylineData;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAlias;
import lcsb.mapviewer.model.map.reaction.Modifier;
import lcsb.mapviewer.model.map.reaction.NodeOperator;
import lcsb.mapviewer.model.map.reaction.Reaction;
import org.apache.log4j.Logger;

public class ModifierTypeUtils {
    private static Logger logger = Logger.getLogger(ModifierTypeUtils.class);

    public ModifierType getModifierTypeForClazz(Class<? extends Modifier> clazz) {
        for (ModifierType modType : ModifierType.values()) {
            if (!clazz.equals(modType.getClazz())) continue;
            return modType;
        }
        return null;
    }

    protected ModifierType getModifierTypeForStringType(String type) {
        for (ModifierType modType : ModifierType.values()) {
            if (!type.equalsIgnoreCase(modType.getStringName())) continue;
            return modType;
        }
        return null;
    }

    public Modifier createModifierForStringType(String type, SpeciesAlias alias, Element element) {
        Modifier mod = null;
        ModifierType modType = this.getModifierTypeForStringType(type);
        if (modType == null) {
            throw new InvalidArgumentException("Unknown modifier type: " + type);
        }
        try {
            mod = modType.getClazz().getConstructor(SpeciesAlias.class, Element.class).newInstance(alias, element);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return mod;
    }

    public String getStringTypeByModifier(Modifier modifier) {
        ModifierType modifierType = this.getModifierTypeForClazz(modifier.getClass());
        if (modifierType != null) {
            return modifierType.getStringName();
        }
        return null;
    }

    public String getTargetLineIndexByModifier(Modifier modifier) {
        ModifierType modType = this.getModifierTypeForClazz(modifier.getClass());
        if (modType == null) {
            throw new InvalidArgumentException("Unknown modifier class: " + modifier.getClass());
        }
        Reaction reaction = modifier.getReaction();
        PolylineData line = modifier.getLine();
        String result = this.getTragteLineIndex(modType, reaction, line);
        return result;
    }

    public String getTargetLineIndexByModifier(NodeOperator modifier) {
        if (!(modifier.getInputs().get(0) instanceof Modifier)) {
            logger.error("Invalid NodeOperator");
            return null;
        }
        ModifierType modType = this.getModifierTypeForClazz(((Modifier)modifier.getInputs().get(0)).getClass());
        if (modType == null) {
            throw new InvalidArgumentException("Unknown modifier class: " + modifier.getClass());
        }
        Reaction reaction = modifier.getReaction();
        PolylineData line = modifier.getLine();
        String result = this.getTragteLineIndex(modType, reaction, line);
        return result;
    }

    private String getTragteLineIndex(ModifierType modType, Reaction reaction, PolylineData originalLine) {
        PolylineData line = new PolylineData(originalLine);
        line.trimEnd(-modType.getTrimLength());
        String[] possibleValues = new String[]{"0,2", "0,3", "0,4", "0,5", "0,6", "0,7"};
        Point2D closestPoint = new Point2D.Double(Double.MAX_VALUE, Double.MAX_VALUE);
        Point2D checkedPoint = line.getEndPoint();
        String result = "0,0";
        for (String string : possibleValues) {
            Point2D point = this.getAnchorPointOnReactionRect(reaction, string);
            if (!(point.distance(checkedPoint) < closestPoint.distance(checkedPoint))) continue;
            closestPoint = point;
            result = string;
        }
        if (closestPoint.distance(checkedPoint) < 1.0E-6) {
            logger.warn("Couldn't find appropriate targetLineIndex");
        }
        return result;
    }

    public Point2D getAnchorPointOnReactionRect(Reaction reaction, String lineConnectionType) {
        Line2D centerLine = reaction.getCenterLine();
        double dx = centerLine.getX2() - centerLine.getX1();
        double dy = centerLine.getY2() - centerLine.getY1();
        double angle = Math.atan2(dy, dx);
        Point2D.Double mid = new Point2D.Double((centerLine.getX1() + centerLine.getX2()) / 2.0, (centerLine.getY1() + centerLine.getY2()) / 2.0);
        String id = lineConnectionType;
        String[] spr = id.split(",");
        double x = ((Point2D)mid).getX();
        double y = ((Point2D)mid).getY();
        if (spr.length > 1) {
            id = spr[1];
            if (id.equals("2")) {
                y -= 5.0;
            } else if (id.equals("3")) {
                y += 5.0;
            } else if (id.equals("4")) {
                y -= 5.0;
                x -= 5.0;
            } else if (id.equals("5")) {
                y -= 5.0;
                x += 5.0;
            } else if (id.equals("6")) {
                y += 5.0;
                x -= 5.0;
            } else if (id.equals("7")) {
                y += 5.0;
                x += 5.0;
            } else if (id.equals("0")) {
                y += 5.0;
            } else {
                logger.debug("Unknown targetLineIndex: " + id);
            }
        } else {
            logger.debug("Invalid targetLineIndex: " + id);
        }
        Point2D p = new Point2D.Double(x, y);
        PointTransformation pointTransformation = new PointTransformation();
        p = pointTransformation.rotatePoint(p, angle, mid);
        return p;
    }

    public void updateLineEndPoint(Modifier modifier) {
        ModifierType modType = this.getModifierTypeForClazz(modifier.getClass());
        if (modType == null) {
            throw new InvalidArgumentException("Unknown modifier class: " + modifier.getClass());
        }
        PolylineData line = modifier.getLine();
        this.updateLineByType(modType, line);
    }

    public void updateLineEndPoint(NodeOperator operator) {
        ModifierType modType;
        Class<?> clazz = operator.getInputs().get(1).getClass();
        if (Modifier.class.isAssignableFrom(clazz)) {
            modType = this.getModifierTypeForClazz(clazz);
            if (modType == null) {
                throw new InvalidArgumentException("Unknown modifier class: " + clazz);
            }
        } else {
            throw new InvalidArgumentException("Operator contains invalid input: " + clazz);
        }
        PolylineData line = operator.getLine();
        this.updateLineByType(modType, line);
    }

    private void updateLineByType(ModifierType modType, PolylineData line) {
        line.setEndAtd(modType.getAtd().copy());
        line.setType(modType.getLineType());
        line.trimEnd(modType.getTrimLength());
    }

    public ModifierType getModifierTypeForOperator(NodeOperator modifierOperator) {
        Modifier mod = (Modifier)modifierOperator.getInputs().get(0);
        return this.getModifierTypeForClazz(mod.getClass());
    }
}

